@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureplaywrightservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * When enabled, Playwright client workers can connect to cloud-hosted browsers. This can increase the number of parallel workers for a test run, significantly minimizing test completion durations.
 */
public enum class EnablementStatus(
    public val javaValue: com.pulumi.azurenative.azureplaywrightservice.enums.EnablementStatus,
) : ConvertibleToJava<com.pulumi.azurenative.azureplaywrightservice.enums.EnablementStatus> {
    /**
     * The feature is Enabled.
     */
    Enabled(com.pulumi.azurenative.azureplaywrightservice.enums.EnablementStatus.Enabled),

    /**
     * The feature is Disabled.
     */
    Disabled(com.pulumi.azurenative.azureplaywrightservice.enums.EnablementStatus.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.azureplaywrightservice.enums.EnablementStatus =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azureplaywrightservice.enums.EnablementStatus): EnablementStatus = EnablementStatus.values().first { it.javaValue == javaType }
    }
}
