@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureplaywrightservice.kotlin.inputs

import com.pulumi.azurenative.azureplaywrightservice.inputs.GetAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of account
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAccountPlainArgs(
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azureplaywrightservice.inputs.GetAccountPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azureplaywrightservice.inputs.GetAccountPlainArgs =
        com.pulumi.azurenative.azureplaywrightservice.inputs.GetAccountPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccountPlainArgs].
 */
@PulumiTagMarker
public class GetAccountPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of account
     */
    @JvmName("dlltgagphxdpdlyi")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("phruhvkqyxnejxkx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAccountPlainArgs = GetAccountPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
