@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin

import com.pulumi.azurenative.azuresphere.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.azuresphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DeviceGroup].
 */
@PulumiTagMarker
public class DeviceGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeviceGroupArgs = DeviceGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeviceGroupArgsBuilder.() -> Unit) {
        val builder = DeviceGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DeviceGroup {
        val builtJavaResource = com.pulumi.azurenative.azuresphere.DeviceGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DeviceGroup(builtJavaResource)
    }
}

/**
 * An device group resource belonging to a product resource.
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2024-04-01.
 * ## Example Usage
 * ### DeviceGroups_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deviceGroup = new AzureNative.AzureSphere.DeviceGroup("deviceGroup", new()
 *     {
 *         CatalogName = "MyCatalog1",
 *         Description = "Description for MyDeviceGroup1",
 *         DeviceGroupName = "MyDeviceGroup1",
 *         OsFeedType = AzureNative.AzureSphere.OSFeedType.Retail,
 *         ProductName = "MyProduct1",
 *         ResourceGroupName = "MyResourceGroup1",
 *         UpdatePolicy = AzureNative.AzureSphere.UpdatePolicy.UpdateAll,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azuresphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azuresphere.NewDeviceGroup(ctx, "deviceGroup", &azuresphere.DeviceGroupArgs{
 * 			CatalogName:       pulumi.String("MyCatalog1"),
 * 			Description:       pulumi.String("Description for MyDeviceGroup1"),
 * 			DeviceGroupName:   pulumi.String("MyDeviceGroup1"),
 * 			OsFeedType:        pulumi.String(azuresphere.OSFeedTypeRetail),
 * 			ProductName:       pulumi.String("MyProduct1"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup1"),
 * 			UpdatePolicy:      pulumi.String(azuresphere.UpdatePolicyUpdateAll),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azuresphere.DeviceGroup;
 * import com.pulumi.azurenative.azuresphere.DeviceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deviceGroup = new DeviceGroup("deviceGroup", DeviceGroupArgs.builder()
 *             .catalogName("MyCatalog1")
 *             .description("Description for MyDeviceGroup1")
 *             .deviceGroupName("MyDeviceGroup1")
 *             .osFeedType("Retail")
 *             .productName("MyProduct1")
 *             .resourceGroupName("MyResourceGroup1")
 *             .updatePolicy("UpdateAll")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azuresphere:DeviceGroup MyDeviceId1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureSphere/catalogs/{catalogName}/products/{productName}/deviceGroups/{deviceGroupName}
 * ```
 */
public class DeviceGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.azuresphere.DeviceGroup,
) : KotlinCustomResource(javaResource, DeviceGroupMapper) {
    /**
     * Flag to define if the user allows for crash dump collection.
     */
    public val allowCrashDumpsCollection: Output<String>?
        get() = javaResource.allowCrashDumpsCollection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of the device group.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Deployment status for the device group.
     */
    public val hasDeployment: Output<Boolean>
        get() = javaResource.hasDeployment().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Operating system feed type of the device group.
     */
    public val osFeedType: Output<String>?
        get() = javaResource.osFeedType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Regional data boundary for the device group.
     */
    public val regionalDataBoundary: Output<String>?
        get() = javaResource.regionalDataBoundary().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Update policy of the device group.
     */
    public val updatePolicy: Output<String>?
        get() = javaResource.updatePolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object DeviceGroupMapper : ResourceMapper<DeviceGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azuresphere.DeviceGroup::class == javaResource::class

    override fun map(javaResource: Resource): DeviceGroup = DeviceGroup(
        javaResource as
            com.pulumi.azurenative.azuresphere.DeviceGroup,
    )
}

/**
 * @see [DeviceGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DeviceGroup].
 */
public suspend fun deviceGroup(name: String, block: suspend DeviceGroupResourceBuilder.() -> Unit): DeviceGroup {
    val builder = DeviceGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DeviceGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deviceGroup(name: String): DeviceGroup {
    val builder = DeviceGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
