@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin

import com.pulumi.azurenative.azuresphere.DeviceGroupArgs.builder
import com.pulumi.azurenative.azuresphere.kotlin.enums.AllowCrashDumpCollection
import com.pulumi.azurenative.azuresphere.kotlin.enums.OSFeedType
import com.pulumi.azurenative.azuresphere.kotlin.enums.RegionalDataBoundary
import com.pulumi.azurenative.azuresphere.kotlin.enums.UpdatePolicy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An device group resource belonging to a product resource.
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2024-04-01.
 * ## Example Usage
 * ### DeviceGroups_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deviceGroup = new AzureNative.AzureSphere.DeviceGroup("deviceGroup", new()
 *     {
 *         CatalogName = "MyCatalog1",
 *         Description = "Description for MyDeviceGroup1",
 *         DeviceGroupName = "MyDeviceGroup1",
 *         OsFeedType = AzureNative.AzureSphere.OSFeedType.Retail,
 *         ProductName = "MyProduct1",
 *         ResourceGroupName = "MyResourceGroup1",
 *         UpdatePolicy = AzureNative.AzureSphere.UpdatePolicy.UpdateAll,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azuresphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azuresphere.NewDeviceGroup(ctx, "deviceGroup", &azuresphere.DeviceGroupArgs{
 * 			CatalogName:       pulumi.String("MyCatalog1"),
 * 			Description:       pulumi.String("Description for MyDeviceGroup1"),
 * 			DeviceGroupName:   pulumi.String("MyDeviceGroup1"),
 * 			OsFeedType:        pulumi.String(azuresphere.OSFeedTypeRetail),
 * 			ProductName:       pulumi.String("MyProduct1"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup1"),
 * 			UpdatePolicy:      pulumi.String(azuresphere.UpdatePolicyUpdateAll),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azuresphere.DeviceGroup;
 * import com.pulumi.azurenative.azuresphere.DeviceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deviceGroup = new DeviceGroup("deviceGroup", DeviceGroupArgs.builder()
 *             .catalogName("MyCatalog1")
 *             .description("Description for MyDeviceGroup1")
 *             .deviceGroupName("MyDeviceGroup1")
 *             .osFeedType("Retail")
 *             .productName("MyProduct1")
 *             .resourceGroupName("MyResourceGroup1")
 *             .updatePolicy("UpdateAll")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azuresphere:DeviceGroup MyDeviceId1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureSphere/catalogs/{catalogName}/products/{productName}/deviceGroups/{deviceGroupName}
 * ```
 * @property allowCrashDumpsCollection Flag to define if the user allows for crash dump collection.
 * @property catalogName Name of catalog
 * @property description Description of the device group.
 * @property deviceGroupName Name of device group.
 * @property osFeedType Operating system feed type of the device group.
 * @property productName Name of product.
 * @property regionalDataBoundary Regional data boundary for the device group.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property updatePolicy Update policy of the device group.
 */
public data class DeviceGroupArgs(
    public val allowCrashDumpsCollection: Output<Either<String, AllowCrashDumpCollection>>? = null,
    public val catalogName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val deviceGroupName: Output<String>? = null,
    public val osFeedType: Output<Either<String, OSFeedType>>? = null,
    public val productName: Output<String>? = null,
    public val regionalDataBoundary: Output<Either<String, RegionalDataBoundary>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val updatePolicy: Output<Either<String, UpdatePolicy>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuresphere.DeviceGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.azuresphere.DeviceGroupArgs =
        com.pulumi.azurenative.azuresphere.DeviceGroupArgs.builder()
            .allowCrashDumpsCollection(
                allowCrashDumpsCollection?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .catalogName(catalogName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .deviceGroupName(deviceGroupName?.applyValue({ args0 -> args0 }))
            .osFeedType(
                osFeedType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .productName(productName?.applyValue({ args0 -> args0 }))
            .regionalDataBoundary(
                regionalDataBoundary?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .updatePolicy(
                updatePolicy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DeviceGroupArgs].
 */
@PulumiTagMarker
public class DeviceGroupArgsBuilder internal constructor() {
    private var allowCrashDumpsCollection: Output<Either<String, AllowCrashDumpCollection>>? = null

    private var catalogName: Output<String>? = null

    private var description: Output<String>? = null

    private var deviceGroupName: Output<String>? = null

    private var osFeedType: Output<Either<String, OSFeedType>>? = null

    private var productName: Output<String>? = null

    private var regionalDataBoundary: Output<Either<String, RegionalDataBoundary>>? = null

    private var resourceGroupName: Output<String>? = null

    private var updatePolicy: Output<Either<String, UpdatePolicy>>? = null

    /**
     * @param value Flag to define if the user allows for crash dump collection.
     */
    @JvmName("icxnbionvkahwwre")
    public suspend fun allowCrashDumpsCollection(`value`: Output<Either<String, AllowCrashDumpCollection>>) {
        this.allowCrashDumpsCollection = value
    }

    /**
     * @param value Name of catalog
     */
    @JvmName("wgucahhxmwvnsvoc")
    public suspend fun catalogName(`value`: Output<String>) {
        this.catalogName = value
    }

    /**
     * @param value Description of the device group.
     */
    @JvmName("lpshuupbotdtllmm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of device group.
     */
    @JvmName("ryqwgsmiisimcoff")
    public suspend fun deviceGroupName(`value`: Output<String>) {
        this.deviceGroupName = value
    }

    /**
     * @param value Operating system feed type of the device group.
     */
    @JvmName("aimndsyfjwkbidst")
    public suspend fun osFeedType(`value`: Output<Either<String, OSFeedType>>) {
        this.osFeedType = value
    }

    /**
     * @param value Name of product.
     */
    @JvmName("eccpvjwcwerdhxsn")
    public suspend fun productName(`value`: Output<String>) {
        this.productName = value
    }

    /**
     * @param value Regional data boundary for the device group.
     */
    @JvmName("tmgcxjexkmulbygw")
    public suspend fun regionalDataBoundary(`value`: Output<Either<String, RegionalDataBoundary>>) {
        this.regionalDataBoundary = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jlaclxsveoqdwsyb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Update policy of the device group.
     */
    @JvmName("syljelaojlkkcpse")
    public suspend fun updatePolicy(`value`: Output<Either<String, UpdatePolicy>>) {
        this.updatePolicy = value
    }

    /**
     * @param value Flag to define if the user allows for crash dump collection.
     */
    @JvmName("egvayjsvldgtaldi")
    public suspend fun allowCrashDumpsCollection(`value`: Either<String, AllowCrashDumpCollection>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowCrashDumpsCollection = mapped
    }

    /**
     * @param value Flag to define if the user allows for crash dump collection.
     */
    @JvmName("fumwgkypusxvblwe")
    public fun allowCrashDumpsCollection(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AllowCrashDumpCollection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowCrashDumpsCollection = mapped
    }

    /**
     * @param value Flag to define if the user allows for crash dump collection.
     */
    @JvmName("nsvwsloftlddasbs")
    public fun allowCrashDumpsCollection(`value`: AllowCrashDumpCollection) {
        val toBeMapped = Either.ofRight<String, AllowCrashDumpCollection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowCrashDumpsCollection = mapped
    }

    /**
     * @param value Name of catalog
     */
    @JvmName("yfmcsmjbsvpyinxc")
    public suspend fun catalogName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogName = mapped
    }

    /**
     * @param value Description of the device group.
     */
    @JvmName("qhdlupfbojcilkxf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of device group.
     */
    @JvmName("graeaiqvbuyslpct")
    public suspend fun deviceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceGroupName = mapped
    }

    /**
     * @param value Operating system feed type of the device group.
     */
    @JvmName("hhdfknhbttgeaqis")
    public suspend fun osFeedType(`value`: Either<String, OSFeedType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osFeedType = mapped
    }

    /**
     * @param value Operating system feed type of the device group.
     */
    @JvmName("cbeenaynsrxfucwt")
    public fun osFeedType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OSFeedType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osFeedType = mapped
    }

    /**
     * @param value Operating system feed type of the device group.
     */
    @JvmName("uqmujonlerlvsokp")
    public fun osFeedType(`value`: OSFeedType) {
        val toBeMapped = Either.ofRight<String, OSFeedType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osFeedType = mapped
    }

    /**
     * @param value Name of product.
     */
    @JvmName("lttyalyrvbdvlmmb")
    public suspend fun productName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productName = mapped
    }

    /**
     * @param value Regional data boundary for the device group.
     */
    @JvmName("yndrpawbrsjgowgc")
    public suspend fun regionalDataBoundary(`value`: Either<String, RegionalDataBoundary>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionalDataBoundary = mapped
    }

    /**
     * @param value Regional data boundary for the device group.
     */
    @JvmName("dpffephvpbbjedsq")
    public fun regionalDataBoundary(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RegionalDataBoundary>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionalDataBoundary = mapped
    }

    /**
     * @param value Regional data boundary for the device group.
     */
    @JvmName("mvejbvlteqxtiyok")
    public fun regionalDataBoundary(`value`: RegionalDataBoundary) {
        val toBeMapped = Either.ofRight<String, RegionalDataBoundary>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionalDataBoundary = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tvpefcwnmkdxsong")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Update policy of the device group.
     */
    @JvmName("piwnmipehhqfxtpj")
    public suspend fun updatePolicy(`value`: Either<String, UpdatePolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updatePolicy = mapped
    }

    /**
     * @param value Update policy of the device group.
     */
    @JvmName("stpejbrlvndyvgjq")
    public fun updatePolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UpdatePolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.updatePolicy = mapped
    }

    /**
     * @param value Update policy of the device group.
     */
    @JvmName("mjswahfpsjwvxtli")
    public fun updatePolicy(`value`: UpdatePolicy) {
        val toBeMapped = Either.ofRight<String, UpdatePolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.updatePolicy = mapped
    }

    internal fun build(): DeviceGroupArgs = DeviceGroupArgs(
        allowCrashDumpsCollection = allowCrashDumpsCollection,
        catalogName = catalogName,
        description = description,
        deviceGroupName = deviceGroupName,
        osFeedType = osFeedType,
        productName = productName,
        regionalDataBoundary = regionalDataBoundary,
        resourceGroupName = resourceGroupName,
        updatePolicy = updatePolicy,
    )
}
