@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Flag to define if the user allows for crash dump collection.
 */
public enum class AllowCrashDumpCollection(
    public val javaValue: com.pulumi.azurenative.azuresphere.enums.AllowCrashDumpCollection,
) : ConvertibleToJava<com.pulumi.azurenative.azuresphere.enums.AllowCrashDumpCollection> {
    /**
     * Crash dump collection enabled
     */
    Enabled(com.pulumi.azurenative.azuresphere.enums.AllowCrashDumpCollection.Enabled),

    /**
     * Crash dump collection disabled
     */
    Disabled(com.pulumi.azurenative.azuresphere.enums.AllowCrashDumpCollection.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.azuresphere.enums.AllowCrashDumpCollection =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuresphere.enums.AllowCrashDumpCollection): AllowCrashDumpCollection =
            AllowCrashDumpCollection.values().first { it.javaValue == javaType }
    }
}
