@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.inputs

import com.pulumi.azurenative.azuresphere.inputs.GetDeploymentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogName Name of catalog
 * @property deploymentName Deployment name. Use .default for deployment creation and to get the current deployment for the associated device group.
 * @property deviceGroupName Name of device group.
 * @property productName Name of product.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDeploymentPlainArgs(
    public val catalogName: String,
    public val deploymentName: String,
    public val deviceGroupName: String,
    public val productName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azuresphere.inputs.GetDeploymentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azuresphere.inputs.GetDeploymentPlainArgs =
        com.pulumi.azurenative.azuresphere.inputs.GetDeploymentPlainArgs.builder()
            .catalogName(catalogName.let({ args0 -> args0 }))
            .deploymentName(deploymentName.let({ args0 -> args0 }))
            .deviceGroupName(deviceGroupName.let({ args0 -> args0 }))
            .productName(productName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDeploymentPlainArgs].
 */
@PulumiTagMarker
public class GetDeploymentPlainArgsBuilder internal constructor() {
    private var catalogName: String? = null

    private var deploymentName: String? = null

    private var deviceGroupName: String? = null

    private var productName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of catalog
     */
    @JvmName("tpqyqjmfupybqnkp")
    public suspend fun catalogName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogName = mapped
    }

    /**
     * @param value Deployment name. Use .default for deployment creation and to get the current deployment for the associated device group.
     */
    @JvmName("vwrjxfbaohfubfex")
    public suspend fun deploymentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentName = mapped
    }

    /**
     * @param value Name of device group.
     */
    @JvmName("kadqrqiemrlajuld")
    public suspend fun deviceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceGroupName = mapped
    }

    /**
     * @param value Name of product.
     */
    @JvmName("kyqjunqmxxtuhrai")
    public suspend fun productName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.productName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hmjelefwkjtrfbdn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDeploymentPlainArgs = GetDeploymentPlainArgs(
        catalogName = catalogName ?: throw PulumiNullFieldException("catalogName"),
        deploymentName = deploymentName ?: throw PulumiNullFieldException("deploymentName"),
        deviceGroupName = deviceGroupName ?: throw PulumiNullFieldException("deviceGroupName"),
        productName = productName ?: throw PulumiNullFieldException("productName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
