@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.inputs

import com.pulumi.azurenative.azuresphere.inputs.GetDeviceGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogName Name of catalog
 * @property deviceGroupName Name of device group.
 * @property productName Name of product.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDeviceGroupPlainArgs(
    public val catalogName: String,
    public val deviceGroupName: String,
    public val productName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azuresphere.inputs.GetDeviceGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azuresphere.inputs.GetDeviceGroupPlainArgs =
        com.pulumi.azurenative.azuresphere.inputs.GetDeviceGroupPlainArgs.builder()
            .catalogName(catalogName.let({ args0 -> args0 }))
            .deviceGroupName(deviceGroupName.let({ args0 -> args0 }))
            .productName(productName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDeviceGroupPlainArgs].
 */
@PulumiTagMarker
public class GetDeviceGroupPlainArgsBuilder internal constructor() {
    private var catalogName: String? = null

    private var deviceGroupName: String? = null

    private var productName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of catalog
     */
    @JvmName("hxpvlygctekfbfpx")
    public suspend fun catalogName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogName = mapped
    }

    /**
     * @param value Name of device group.
     */
    @JvmName("envpasxcilpsopys")
    public suspend fun deviceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceGroupName = mapped
    }

    /**
     * @param value Name of product.
     */
    @JvmName("ffqroigpspjkdfus")
    public suspend fun productName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.productName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("spqaudkxjbfewwhw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDeviceGroupPlainArgs = GetDeviceGroupPlainArgs(
        catalogName = catalogName ?: throw PulumiNullFieldException("catalogName"),
        deviceGroupName = deviceGroupName ?: throw PulumiNullFieldException("deviceGroupName"),
        productName = productName ?: throw PulumiNullFieldException("productName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
