@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.inputs

import com.pulumi.azurenative.azuresphere.inputs.GetProductPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogName Name of catalog
 * @property productName Name of product.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetProductPlainArgs(
    public val catalogName: String,
    public val productName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azuresphere.inputs.GetProductPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azuresphere.inputs.GetProductPlainArgs =
        com.pulumi.azurenative.azuresphere.inputs.GetProductPlainArgs.builder()
            .catalogName(catalogName.let({ args0 -> args0 }))
            .productName(productName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProductPlainArgs].
 */
@PulumiTagMarker
public class GetProductPlainArgsBuilder internal constructor() {
    private var catalogName: String? = null

    private var productName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of catalog
     */
    @JvmName("syqcjodjkgofqcci")
    public suspend fun catalogName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogName = mapped
    }

    /**
     * @param value Name of product.
     */
    @JvmName("rnrwbitgaiherwej")
    public suspend fun productName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.productName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bxpbmashpkaonjup")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetProductPlainArgs = GetProductPlainArgs(
        catalogName = catalogName ?: throw PulumiNullFieldException("catalogName"),
        productName = productName ?: throw PulumiNullFieldException("productName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
