@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.inputs

import com.pulumi.azurenative.azuresphere.inputs.ListCatalogDeploymentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogName Name of catalog
 * @property filter Filter the result list using the given expression
 * @property maxpagesize The maximum number of result items per page.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property skip The number of result items to skip.
 * @property top The number of result items to return.
 */
public data class ListCatalogDeploymentsPlainArgs(
    public val catalogName: String,
    public val filter: String? = null,
    public val maxpagesize: Int? = null,
    public val resourceGroupName: String,
    public val skip: Int? = null,
    public val top: Int? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuresphere.inputs.ListCatalogDeploymentsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azuresphere.inputs.ListCatalogDeploymentsPlainArgs =
        com.pulumi.azurenative.azuresphere.inputs.ListCatalogDeploymentsPlainArgs.builder()
            .catalogName(catalogName.let({ args0 -> args0 }))
            .filter(filter?.let({ args0 -> args0 }))
            .maxpagesize(maxpagesize?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .skip(skip?.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListCatalogDeploymentsPlainArgs].
 */
@PulumiTagMarker
public class ListCatalogDeploymentsPlainArgsBuilder internal constructor() {
    private var catalogName: String? = null

    private var filter: String? = null

    private var maxpagesize: Int? = null

    private var resourceGroupName: String? = null

    private var skip: Int? = null

    private var top: Int? = null

    /**
     * @param value Name of catalog
     */
    @JvmName("enhitqwhcqjcibuu")
    public suspend fun catalogName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogName = mapped
    }

    /**
     * @param value Filter the result list using the given expression
     */
    @JvmName("fatdjnayvjtqrfls")
    public suspend fun filter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filter = mapped
    }

    /**
     * @param value The maximum number of result items per page.
     */
    @JvmName("jyrqprjlugyodtld")
    public suspend fun maxpagesize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.maxpagesize = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dauivxxyxemwuumn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The number of result items to skip.
     */
    @JvmName("bxlsglftbjvrtgic")
    public suspend fun skip(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skip = mapped
    }

    /**
     * @param value The number of result items to return.
     */
    @JvmName("ikbselxhiiuultju")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    internal fun build(): ListCatalogDeploymentsPlainArgs = ListCatalogDeploymentsPlainArgs(
        catalogName = catalogName ?: throw PulumiNullFieldException("catalogName"),
        filter = filter,
        maxpagesize = maxpagesize,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        skip = skip,
        top = top,
    )
}
