@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An deployment resource belonging to a device group resource.
 * @property deployedImages Images deployed
 * @property deploymentDateUtc Deployment date UTC
 * @property deploymentId Deployment ID
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState The status of the last operation.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class DeploymentResponse(
    public val deployedImages: List<ImageResponse>? = null,
    public val deploymentDateUtc: String,
    public val deploymentId: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuresphere.outputs.DeploymentResponse): DeploymentResponse = DeploymentResponse(
            deployedImages = javaType.deployedImages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azuresphere.kotlin.outputs.ImageResponse.Companion.toKotlin(args0)
                })
            }),
            deploymentDateUtc = javaType.deploymentDateUtc(),
            deploymentId = javaType.deploymentId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azuresphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
