@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The response of a DeviceGroup list operation.
 * @property nextLink The link to the next page of items
 * @property value The DeviceGroup items on this page
 */
public data class ListCatalogDeviceGroupsResult(
    public val nextLink: String,
    public val `value`: List<DeviceGroupResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuresphere.outputs.ListCatalogDeviceGroupsResult): ListCatalogDeviceGroupsResult = ListCatalogDeviceGroupsResult(
            nextLink = javaType.nextLink(),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azuresphere.kotlin.outputs.DeviceGroupResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
