@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin

import com.pulumi.azurenative.azurestack.AzurestackFunctions.getCustomerSubscriptionPlain
import com.pulumi.azurenative.azurestack.AzurestackFunctions.getLinkedSubscriptionPlain
import com.pulumi.azurenative.azurestack.AzurestackFunctions.getProductPlain
import com.pulumi.azurenative.azurestack.AzurestackFunctions.getProductsPlain
import com.pulumi.azurenative.azurestack.AzurestackFunctions.getRegistrationActivationKeyPlain
import com.pulumi.azurenative.azurestack.AzurestackFunctions.getRegistrationPlain
import com.pulumi.azurenative.azurestack.AzurestackFunctions.listProductDetailsPlain
import com.pulumi.azurenative.azurestack.AzurestackFunctions.listProductsPlain
import com.pulumi.azurenative.azurestack.kotlin.inputs.GetCustomerSubscriptionPlainArgs
import com.pulumi.azurenative.azurestack.kotlin.inputs.GetCustomerSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.azurestack.kotlin.inputs.GetLinkedSubscriptionPlainArgs
import com.pulumi.azurenative.azurestack.kotlin.inputs.GetLinkedSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.azurestack.kotlin.inputs.GetProductPlainArgs
import com.pulumi.azurenative.azurestack.kotlin.inputs.GetProductPlainArgsBuilder
import com.pulumi.azurenative.azurestack.kotlin.inputs.GetProductsPlainArgs
import com.pulumi.azurenative.azurestack.kotlin.inputs.GetProductsPlainArgsBuilder
import com.pulumi.azurenative.azurestack.kotlin.inputs.GetRegistrationActivationKeyPlainArgs
import com.pulumi.azurenative.azurestack.kotlin.inputs.GetRegistrationActivationKeyPlainArgsBuilder
import com.pulumi.azurenative.azurestack.kotlin.inputs.GetRegistrationPlainArgs
import com.pulumi.azurenative.azurestack.kotlin.inputs.GetRegistrationPlainArgsBuilder
import com.pulumi.azurenative.azurestack.kotlin.inputs.ListProductDetailsPlainArgs
import com.pulumi.azurenative.azurestack.kotlin.inputs.ListProductDetailsPlainArgsBuilder
import com.pulumi.azurenative.azurestack.kotlin.inputs.ListProductsPlainArgs
import com.pulumi.azurenative.azurestack.kotlin.inputs.ListProductsPlainArgsBuilder
import com.pulumi.azurenative.azurestack.kotlin.outputs.GetCustomerSubscriptionResult
import com.pulumi.azurenative.azurestack.kotlin.outputs.GetLinkedSubscriptionResult
import com.pulumi.azurenative.azurestack.kotlin.outputs.GetProductResult
import com.pulumi.azurenative.azurestack.kotlin.outputs.GetProductsResult
import com.pulumi.azurenative.azurestack.kotlin.outputs.GetRegistrationActivationKeyResult
import com.pulumi.azurenative.azurestack.kotlin.outputs.GetRegistrationResult
import com.pulumi.azurenative.azurestack.kotlin.outputs.ListProductDetailsResult
import com.pulumi.azurenative.azurestack.kotlin.outputs.ListProductsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.azurestack.kotlin.outputs.GetCustomerSubscriptionResult.Companion.toKotlin as getCustomerSubscriptionResultToKotlin
import com.pulumi.azurenative.azurestack.kotlin.outputs.GetLinkedSubscriptionResult.Companion.toKotlin as getLinkedSubscriptionResultToKotlin
import com.pulumi.azurenative.azurestack.kotlin.outputs.GetProductResult.Companion.toKotlin as getProductResultToKotlin
import com.pulumi.azurenative.azurestack.kotlin.outputs.GetProductsResult.Companion.toKotlin as getProductsResultToKotlin
import com.pulumi.azurenative.azurestack.kotlin.outputs.GetRegistrationActivationKeyResult.Companion.toKotlin as getRegistrationActivationKeyResultToKotlin
import com.pulumi.azurenative.azurestack.kotlin.outputs.GetRegistrationResult.Companion.toKotlin as getRegistrationResultToKotlin
import com.pulumi.azurenative.azurestack.kotlin.outputs.ListProductDetailsResult.Companion.toKotlin as listProductDetailsResultToKotlin
import com.pulumi.azurenative.azurestack.kotlin.outputs.ListProductsResult.Companion.toKotlin as listProductsResultToKotlin

public object AzurestackFunctions {
    /**
     * Returns the specified product.
     * Azure REST API version: 2022-06-01.
     * Other available API versions: 2020-06-01-preview.
     * @param argument null
     * @return Customer subscription.
     */
    public suspend fun getCustomerSubscription(argument: GetCustomerSubscriptionPlainArgs): GetCustomerSubscriptionResult =
        getCustomerSubscriptionResultToKotlin(getCustomerSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getCustomerSubscription].
     * @param customerSubscriptionName Name of the product.
     * @param registrationName Name of the Azure Stack registration.
     * @param resourceGroup Name of the resource group.
     * @return Customer subscription.
     */
    public suspend fun getCustomerSubscription(
        customerSubscriptionName: String,
        registrationName: String,
        resourceGroup: String,
    ): GetCustomerSubscriptionResult {
        val argument = GetCustomerSubscriptionPlainArgs(
            customerSubscriptionName = customerSubscriptionName,
            registrationName = registrationName,
            resourceGroup = resourceGroup,
        )
        return getCustomerSubscriptionResultToKotlin(getCustomerSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomerSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestack&#46;kotlin&#46;inputs&#46;GetCustomerSubscriptionPlainArgs].
     * @return Customer subscription.
     */
    public suspend fun getCustomerSubscription(argument: suspend GetCustomerSubscriptionPlainArgsBuilder.() -> Unit): GetCustomerSubscriptionResult {
        val builder = GetCustomerSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomerSubscriptionResultToKotlin(getCustomerSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the properties of a Linked Subscription resource.
     * Azure REST API version: 2020-06-01-preview.
     * @param argument null
     * @return Linked Subscription information.
     */
    public suspend fun getLinkedSubscription(argument: GetLinkedSubscriptionPlainArgs): GetLinkedSubscriptionResult =
        getLinkedSubscriptionResultToKotlin(getLinkedSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getLinkedSubscription].
     * @param linkedSubscriptionName Name of the Linked Subscription resource.
     * @param resourceGroup Name of the resource group.
     * @return Linked Subscription information.
     */
    public suspend fun getLinkedSubscription(linkedSubscriptionName: String, resourceGroup: String): GetLinkedSubscriptionResult {
        val argument = GetLinkedSubscriptionPlainArgs(
            linkedSubscriptionName = linkedSubscriptionName,
            resourceGroup = resourceGroup,
        )
        return getLinkedSubscriptionResultToKotlin(getLinkedSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getLinkedSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestack&#46;kotlin&#46;inputs&#46;GetLinkedSubscriptionPlainArgs].
     * @return Linked Subscription information.
     */
    public suspend fun getLinkedSubscription(argument: suspend GetLinkedSubscriptionPlainArgsBuilder.() -> Unit): GetLinkedSubscriptionResult {
        val builder = GetLinkedSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLinkedSubscriptionResultToKotlin(getLinkedSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the specified product.
     * Azure REST API version: 2022-06-01.
     * Other available API versions: 2020-06-01-preview.
     * @param argument null
     * @return Product information.
     */
    public suspend fun getProduct(argument: GetProductPlainArgs): GetProductResult =
        getProductResultToKotlin(getProductPlain(argument.toJava()).await())

    /**
     * @see [getProduct].
     * @param productName Name of the product.
     * @param registrationName Name of the Azure Stack registration.
     * @param resourceGroup Name of the resource group.
     * @return Product information.
     */
    public suspend fun getProduct(
        productName: String,
        registrationName: String,
        resourceGroup: String,
    ): GetProductResult {
        val argument = GetProductPlainArgs(
            productName = productName,
            registrationName = registrationName,
            resourceGroup = resourceGroup,
        )
        return getProductResultToKotlin(getProductPlain(argument.toJava()).await())
    }

    /**
     * @see [getProduct].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestack&#46;kotlin&#46;inputs&#46;GetProductPlainArgs].
     * @return Product information.
     */
    public suspend fun getProduct(argument: suspend GetProductPlainArgsBuilder.() -> Unit): GetProductResult {
        val builder = GetProductPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProductResultToKotlin(getProductPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a list of products.
     * Azure REST API version: 2022-06-01.
     * Other available API versions: 2020-06-01-preview.
     * @param argument null
     * @return Pageable list of products.
     */
    public suspend fun getProducts(argument: GetProductsPlainArgs): GetProductsResult =
        getProductsResultToKotlin(getProductsPlain(argument.toJava()).await())

    /**
     * @see [getProducts].
     * @param productName Name of the product.
     * @param registrationName Name of the Azure Stack registration.
     * @param resourceGroup Name of the resource group.
     * @return Pageable list of products.
     */
    public suspend fun getProducts(
        productName: String,
        registrationName: String,
        resourceGroup: String,
    ): GetProductsResult {
        val argument = GetProductsPlainArgs(
            productName = productName,
            registrationName = registrationName,
            resourceGroup = resourceGroup,
        )
        return getProductsResultToKotlin(getProductsPlain(argument.toJava()).await())
    }

    /**
     * @see [getProducts].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestack&#46;kotlin&#46;inputs&#46;GetProductsPlainArgs].
     * @return Pageable list of products.
     */
    public suspend fun getProducts(argument: suspend GetProductsPlainArgsBuilder.() -> Unit): GetProductsResult {
        val builder = GetProductsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProductsResultToKotlin(getProductsPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the properties of an Azure Stack registration.
     * Azure REST API version: 2022-06-01.
     * Other available API versions: 2020-06-01-preview.
     * @param argument null
     * @return Registration information.
     */
    public suspend fun getRegistration(argument: GetRegistrationPlainArgs): GetRegistrationResult =
        getRegistrationResultToKotlin(getRegistrationPlain(argument.toJava()).await())

    /**
     * @see [getRegistration].
     * @param registrationName Name of the Azure Stack registration.
     * @param resourceGroup Name of the resource group.
     * @return Registration information.
     */
    public suspend fun getRegistration(registrationName: String, resourceGroup: String): GetRegistrationResult {
        val argument = GetRegistrationPlainArgs(
            registrationName = registrationName,
            resourceGroup = resourceGroup,
        )
        return getRegistrationResultToKotlin(getRegistrationPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestack&#46;kotlin&#46;inputs&#46;GetRegistrationPlainArgs].
     * @return Registration information.
     */
    public suspend fun getRegistration(argument: suspend GetRegistrationPlainArgsBuilder.() -> Unit): GetRegistrationResult {
        val builder = GetRegistrationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistrationResultToKotlin(getRegistrationPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns Azure Stack Activation Key.
     * Azure REST API version: 2022-06-01.
     * Other available API versions: 2020-06-01-preview.
     * @param argument null
     * @return The resource containing the Azure Stack activation key.
     */
    public suspend fun getRegistrationActivationKey(argument: GetRegistrationActivationKeyPlainArgs): GetRegistrationActivationKeyResult =
        getRegistrationActivationKeyResultToKotlin(getRegistrationActivationKeyPlain(argument.toJava()).await())

    /**
     * @see [getRegistrationActivationKey].
     * @param registrationName Name of the Azure Stack registration.
     * @param resourceGroup Name of the resource group.
     * @return The resource containing the Azure Stack activation key.
     */
    public suspend fun getRegistrationActivationKey(registrationName: String, resourceGroup: String): GetRegistrationActivationKeyResult {
        val argument = GetRegistrationActivationKeyPlainArgs(
            registrationName = registrationName,
            resourceGroup = resourceGroup,
        )
        return getRegistrationActivationKeyResultToKotlin(getRegistrationActivationKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistrationActivationKey].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestack&#46;kotlin&#46;inputs&#46;GetRegistrationActivationKeyPlainArgs].
     * @return The resource containing the Azure Stack activation key.
     */
    public suspend fun getRegistrationActivationKey(argument: suspend GetRegistrationActivationKeyPlainArgsBuilder.() -> Unit): GetRegistrationActivationKeyResult {
        val builder = GetRegistrationActivationKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistrationActivationKeyResultToKotlin(getRegistrationActivationKeyPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the extended properties of a product.
     * Azure REST API version: 2022-06-01.
     * Other available API versions: 2020-06-01-preview.
     * @param argument null
     * @return Extended description about the product required for installing it into Azure Stack.
     */
    public suspend fun listProductDetails(argument: ListProductDetailsPlainArgs): ListProductDetailsResult =
        listProductDetailsResultToKotlin(listProductDetailsPlain(argument.toJava()).await())

    /**
     * @see [listProductDetails].
     * @param productName Name of the product.
     * @param registrationName Name of the Azure Stack registration.
     * @param resourceGroup Name of the resource group.
     * @return Extended description about the product required for installing it into Azure Stack.
     */
    public suspend fun listProductDetails(
        productName: String,
        registrationName: String,
        resourceGroup: String,
    ): ListProductDetailsResult {
        val argument = ListProductDetailsPlainArgs(
            productName = productName,
            registrationName = registrationName,
            resourceGroup = resourceGroup,
        )
        return listProductDetailsResultToKotlin(listProductDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [listProductDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestack&#46;kotlin&#46;inputs&#46;ListProductDetailsPlainArgs].
     * @return Extended description about the product required for installing it into Azure Stack.
     */
    public suspend fun listProductDetails(argument: suspend ListProductDetailsPlainArgsBuilder.() -> Unit): ListProductDetailsResult {
        val builder = ListProductDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listProductDetailsResultToKotlin(listProductDetailsPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a list of products.
     * Azure REST API version: 2022-06-01.
     * @param argument null
     * @return Pageable list of products.
     */
    public suspend fun listProducts(argument: ListProductsPlainArgs): ListProductsResult =
        listProductsResultToKotlin(listProductsPlain(argument.toJava()).await())

    /**
     * @see [listProducts].
     * @param productName Name of the product.
     * @param registrationName Name of the Azure Stack registration.
     * @param resourceGroup Name of the resource group.
     * @return Pageable list of products.
     */
    public suspend fun listProducts(
        productName: String,
        registrationName: String,
        resourceGroup: String,
    ): ListProductsResult {
        val argument = ListProductsPlainArgs(
            productName = productName,
            registrationName = registrationName,
            resourceGroup = resourceGroup,
        )
        return listProductsResultToKotlin(listProductsPlain(argument.toJava()).await())
    }

    /**
     * @see [listProducts].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestack&#46;kotlin&#46;inputs&#46;ListProductsPlainArgs].
     * @return Pageable list of products.
     */
    public suspend fun listProducts(argument: suspend ListProductsPlainArgsBuilder.() -> Unit): ListProductsResult {
        val builder = ListProductsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listProductsResultToKotlin(listProductsPlain(builtArgument.toJava()).await())
    }
}
