@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Product compatibility
 * @property description Full error message if any compatibility issues are found
 * @property isCompatible Tells if product is compatible with current device
 * @property issues List of all issues found
 * @property message Short error message if any compatibility issues are found
 */
public data class CompatibilityResponse(
    public val description: String? = null,
    public val isCompatible: Boolean? = null,
    public val issues: List<String>? = null,
    public val message: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestack.outputs.CompatibilityResponse): CompatibilityResponse = CompatibilityResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            isCompatible = javaType.isCompatible().map({ args0 -> args0 }).orElse(null),
            issues = javaType.issues().map({ args0 -> args0 }),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
        )
    }
}
