@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Customer subscription.
 * @property etag The entity tag used for optimistic concurrency when modifying the resource.
 * @property id ID of the resource.
 * @property name Name of the resource.
 * @property tenantId Tenant Id.
 * @property type Type of Resource.
 */
public data class GetCustomerSubscriptionResult(
    public val etag: String? = null,
    public val id: String,
    public val name: String,
    public val tenantId: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestack.outputs.GetCustomerSubscriptionResult): GetCustomerSubscriptionResult = GetCustomerSubscriptionResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
