@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Linked Subscription information.
 * @property deviceConnectionStatus The status of the remote management connection of the Azure Stack device.
 * @property deviceId The identifier of the Azure Stack device for remote management.
 * @property deviceLinkState The connection state of the Azure Stack device.
 * @property deviceObjectId The object identifier associated with the Azure Stack device connecting to Azure.
 * @property etag The entity tag used for optimistic concurrency when modifying the resource.
 * @property id ID of the resource.
 * @property kind The kind of the resource.
 * @property lastConnectedTime The last remote management connection time for the Azure Stack device connected to the linked subscription resource.
 * @property linkedSubscriptionId The identifier associated with the device subscription.
 * @property location Location of the resource.
 * @property name Name of the resource.
 * @property registrationResourceId The identifier associated with the device registration.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Custom tags for the resource.
 * @property type Type of Resource.
 */
public data class GetLinkedSubscriptionResult(
    public val deviceConnectionStatus: String,
    public val deviceId: String,
    public val deviceLinkState: String,
    public val deviceObjectId: String,
    public val etag: String? = null,
    public val id: String,
    public val kind: String,
    public val lastConnectedTime: String,
    public val linkedSubscriptionId: String? = null,
    public val location: String,
    public val name: String,
    public val registrationResourceId: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestack.outputs.GetLinkedSubscriptionResult): GetLinkedSubscriptionResult = GetLinkedSubscriptionResult(
            deviceConnectionStatus = javaType.deviceConnectionStatus(),
            deviceId = javaType.deviceId(),
            deviceLinkState = javaType.deviceLinkState(),
            deviceObjectId = javaType.deviceObjectId(),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            lastConnectedTime = javaType.lastConnectedTime(),
            linkedSubscriptionId = javaType.linkedSubscriptionId().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            registrationResourceId = javaType.registrationResourceId().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azurestack.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
