@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Product information.
 * @property billingPartNumber The part number used for billing purposes.
 * @property compatibility Product compatibility with current device.
 * @property description The description of the product.
 * @property displayName The display name of the product.
 * @property etag The entity tag used for optimistic concurrency when modifying the resource.
 * @property galleryItemIdentity The identifier of the gallery item corresponding to the product.
 * @property iconUris Additional links available for this product.
 * @property id ID of the resource.
 * @property legalTerms The legal terms.
 * @property links Additional links available for this product.
 * @property name Name of the resource.
 * @property offer The offer representing the product.
 * @property offerVersion The version of the product offer.
 * @property payloadLength The length of product content.
 * @property privacyPolicy The privacy policy.
 * @property productKind The kind of the product (virtualMachine or virtualMachineExtension)
 * @property productProperties Additional properties for the product.
 * @property publisherDisplayName The user-friendly name of the product publisher.
 * @property publisherIdentifier Publisher identifier.
 * @property sku The product SKU.
 * @property type Type of Resource.
 * @property vmExtensionType The type of the Virtual Machine Extension.
 */
public data class GetProductResult(
    public val billingPartNumber: String? = null,
    public val compatibility: CompatibilityResponse? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val etag: String? = null,
    public val galleryItemIdentity: String? = null,
    public val iconUris: IconUrisResponse? = null,
    public val id: String,
    public val legalTerms: String? = null,
    public val links: List<ProductLinkResponse>? = null,
    public val name: String,
    public val offer: String? = null,
    public val offerVersion: String? = null,
    public val payloadLength: Double? = null,
    public val privacyPolicy: String? = null,
    public val productKind: String? = null,
    public val productProperties: ProductPropertiesResponse? = null,
    public val publisherDisplayName: String? = null,
    public val publisherIdentifier: String? = null,
    public val sku: String? = null,
    public val type: String,
    public val vmExtensionType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestack.outputs.GetProductResult): GetProductResult = GetProductResult(
            billingPartNumber = javaType.billingPartNumber().map({ args0 -> args0 }).orElse(null),
            compatibility = javaType.compatibility().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestack.kotlin.outputs.CompatibilityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            galleryItemIdentity = javaType.galleryItemIdentity().map({ args0 -> args0 }).orElse(null),
            iconUris = javaType.iconUris().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestack.kotlin.outputs.IconUrisResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            legalTerms = javaType.legalTerms().map({ args0 -> args0 }).orElse(null),
            links = javaType.links().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestack.kotlin.outputs.ProductLinkResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            offer = javaType.offer().map({ args0 -> args0 }).orElse(null),
            offerVersion = javaType.offerVersion().map({ args0 -> args0 }).orElse(null),
            payloadLength = javaType.payloadLength().map({ args0 -> args0 }).orElse(null),
            privacyPolicy = javaType.privacyPolicy().map({ args0 -> args0 }).orElse(null),
            productKind = javaType.productKind().map({ args0 -> args0 }).orElse(null),
            productProperties = javaType.productProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestack.kotlin.outputs.ProductPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            publisherDisplayName = javaType.publisherDisplayName().map({ args0 -> args0 }).orElse(null),
            publisherIdentifier = javaType.publisherIdentifier().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            vmExtensionType = javaType.vmExtensionType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
