@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Pageable list of products.
 * @property nextLink URI to the next page.
 * @property value List of products.
 */
public data class GetProductsResult(
    public val nextLink: String? = null,
    public val `value`: List<ProductResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestack.outputs.GetProductsResult): GetProductsResult = GetProductsResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestack.kotlin.outputs.ProductResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
