@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Link with additional information about a product.
 * @property displayName The description of the link.
 * @property uri The URI corresponding to the link.
 */
public data class ProductLinkResponse(
    public val displayName: String? = null,
    public val uri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestack.outputs.ProductLinkResponse): ProductLinkResponse = ProductLinkResponse(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
