@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.LogicalNetworkArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.LogicalNetworkPropertiesDhcpOptionsArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.LogicalNetworkPropertiesDhcpOptionsArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.SubnetArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.SubnetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The logical network resource definition.
 * Azure REST API version: 2023-09-01-preview.
 * Other available API versions: 2024-01-01.
 * ## Example Usage
 * ### PutLogicalNetwork
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var logicalNetwork = new AzureNative.AzureStackHCI.LogicalNetwork("logicalNetwork", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = AzureNative.AzureStackHCI.ExtendedLocationTypes.CustomLocation,
 *         },
 *         Location = "West US2",
 *         LogicalNetworkName = "test-lnet",
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewLogicalNetwork(ctx, "logicalNetwork", &azurestackhci.LogicalNetworkArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String(azurestackhci.ExtendedLocationTypesCustomLocation),
 * 			},
 * 			Location:           pulumi.String("West US2"),
 * 			LogicalNetworkName: pulumi.String("test-lnet"),
 * 			ResourceGroupName:  pulumi.String("test-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.LogicalNetwork;
 * import com.pulumi.azurenative.azurestackhci.LogicalNetworkArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var logicalNetwork = new LogicalNetwork("logicalNetwork", LogicalNetworkArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("West US2")
 *             .logicalNetworkName("test-lnet")
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:LogicalNetwork test-lnet /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/logicalNetworks/{logicalNetworkName}
 * ```
 * @property dhcpOptions DhcpOptions contains an array of DNS servers available to VMs deployed in the logical network. Standard DHCP option for a subnet overrides logical network DHCP options.
 * @property extendedLocation The extendedLocation of the resource.
 * @property location The geo-location where the resource lives
 * @property logicalNetworkName Name of the logical network
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property subnets Subnet - list of subnets under the logical network
 * @property tags Resource tags.
 * @property vmSwitchName name of the network switch to be used for VMs
 */
public data class LogicalNetworkArgs(
    public val dhcpOptions: Output<LogicalNetworkPropertiesDhcpOptionsArgs>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val logicalNetworkName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subnets: Output<List<SubnetArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vmSwitchName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.LogicalNetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.LogicalNetworkArgs =
        com.pulumi.azurenative.azurestackhci.LogicalNetworkArgs.builder()
            .dhcpOptions(dhcpOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .logicalNetworkName(logicalNetworkName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subnets(
                subnets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vmSwitchName(vmSwitchName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogicalNetworkArgs].
 */
@PulumiTagMarker
public class LogicalNetworkArgsBuilder internal constructor() {
    private var dhcpOptions: Output<LogicalNetworkPropertiesDhcpOptionsArgs>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var logicalNetworkName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var subnets: Output<List<SubnetArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vmSwitchName: Output<String>? = null

    /**
     * @param value DhcpOptions contains an array of DNS servers available to VMs deployed in the logical network. Standard DHCP option for a subnet overrides logical network DHCP options.
     */
    @JvmName("vtmxcqjwfstdfviv")
    public suspend fun dhcpOptions(`value`: Output<LogicalNetworkPropertiesDhcpOptionsArgs>) {
        this.dhcpOptions = value
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("spbbxrtpptgkcmge")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("cwvyuvygvuwwcddq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the logical network
     */
    @JvmName("qcbtcnraogspcgwu")
    public suspend fun logicalNetworkName(`value`: Output<String>) {
        this.logicalNetworkName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hwxprqbsxjayldil")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Subnet - list of subnets under the logical network
     */
    @JvmName("rtmiophbbrlmbixh")
    public suspend fun subnets(`value`: Output<List<SubnetArgs>>) {
        this.subnets = value
    }

    @JvmName("ikjberpagitbaoye")
    public suspend fun subnets(vararg values: Output<SubnetArgs>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values Subnet - list of subnets under the logical network
     */
    @JvmName("wnotsbyokeyvfvnu")
    public suspend fun subnets(values: List<Output<SubnetArgs>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("stctrcohvitutqmu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value name of the network switch to be used for VMs
     */
    @JvmName("dlsdkwysuwqcjqex")
    public suspend fun vmSwitchName(`value`: Output<String>) {
        this.vmSwitchName = value
    }

    /**
     * @param value DhcpOptions contains an array of DNS servers available to VMs deployed in the logical network. Standard DHCP option for a subnet overrides logical network DHCP options.
     */
    @JvmName("ugafdqodfapenlkr")
    public suspend fun dhcpOptions(`value`: LogicalNetworkPropertiesDhcpOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dhcpOptions = mapped
    }

    /**
     * @param argument DhcpOptions contains an array of DNS servers available to VMs deployed in the logical network. Standard DHCP option for a subnet overrides logical network DHCP options.
     */
    @JvmName("tdduuvwaatkinixq")
    public suspend fun dhcpOptions(argument: suspend LogicalNetworkPropertiesDhcpOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = LogicalNetworkPropertiesDhcpOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dhcpOptions = mapped
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("oadrecycilultfjm")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extendedLocation of the resource.
     */
    @JvmName("ckluobywldqyimfm")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ygetsjcauwbpuvir")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the logical network
     */
    @JvmName("uxlsuibpuujpxaiv")
    public suspend fun logicalNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logicalNetworkName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mhxfsjblinahvqtl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Subnet - list of subnets under the logical network
     */
    @JvmName("cxpuvnaldotltast")
    public suspend fun subnets(`value`: List<SubnetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param argument Subnet - list of subnets under the logical network
     */
    @JvmName("puvuabwsllesbeuu")
    public suspend fun subnets(argument: List<suspend SubnetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubnetArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param argument Subnet - list of subnets under the logical network
     */
    @JvmName("mwasndrfgechgbkt")
    public suspend fun subnets(vararg argument: suspend SubnetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubnetArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param argument Subnet - list of subnets under the logical network
     */
    @JvmName("xrqtclcyjlyaiowq")
    public suspend fun subnets(argument: suspend SubnetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubnetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param values Subnet - list of subnets under the logical network
     */
    @JvmName("vwmvvtqkwffmwpfq")
    public suspend fun subnets(vararg values: SubnetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hhopwwcxryrinmbb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("hhjwcwakuqmxredb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value name of the network switch to be used for VMs
     */
    @JvmName("oltuioopduagcuac")
    public suspend fun vmSwitchName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSwitchName = mapped
    }

    internal fun build(): LogicalNetworkArgs = LogicalNetworkArgs(
        dhcpOptions = dhcpOptions,
        extendedLocation = extendedLocation,
        location = location,
        logicalNetworkName = logicalNetworkName,
        resourceGroupName = resourceGroupName,
        subnets = subnets,
        tags = tags,
        vmSwitchName = vmSwitchName,
    )
}
