@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.SecuritySettingArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.enums.ComplianceAssignmentType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Security settings proxy resource
 * Azure REST API version: 2023-11-01-preview.
 * Other available API versions: 2024-01-01, 2024-02-15-preview.
 * ## Example Usage
 * ### Create Security Settings
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securitySetting = new AzureNative.AzureStackHCI.SecuritySetting("securitySetting", new()
 *     {
 *         ClusterName = "myCluster",
 *         ResourceGroupName = "test-rg",
 *         SecuredCoreComplianceAssignment = AzureNative.AzureStackHCI.ComplianceAssignmentType.Audit,
 *         SecuritySettingsName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewSecuritySetting(ctx, "securitySetting", &azurestackhci.SecuritySettingArgs{
 * 			ClusterName:                     pulumi.String("myCluster"),
 * 			ResourceGroupName:               pulumi.String("test-rg"),
 * 			SecuredCoreComplianceAssignment: pulumi.String(azurestackhci.ComplianceAssignmentTypeAudit),
 * 			SecuritySettingsName:            pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.SecuritySetting;
 * import com.pulumi.azurenative.azurestackhci.SecuritySettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securitySetting = new SecuritySetting("securitySetting", SecuritySettingArgs.builder()
 *             .clusterName("myCluster")
 *             .resourceGroupName("test-rg")
 *             .securedCoreComplianceAssignment("Audit")
 *             .securitySettingsName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:SecuritySetting myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/securitySettings/{securitySettingsName}
 * ```
 * @property clusterName The name of the cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property securedCoreComplianceAssignment Secured Core Compliance Assignment
 * @property securitySettingsName Name of security setting
 */
public data class SecuritySettingArgs(
    public val clusterName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securedCoreComplianceAssignment: Output<Either<String, ComplianceAssignmentType>>? =
        null,
    public val securitySettingsName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.SecuritySettingArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.SecuritySettingArgs =
        com.pulumi.azurenative.azurestackhci.SecuritySettingArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securedCoreComplianceAssignment(
                securedCoreComplianceAssignment?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .securitySettingsName(securitySettingsName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecuritySettingArgs].
 */
@PulumiTagMarker
public class SecuritySettingArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var securedCoreComplianceAssignment: Output<Either<String, ComplianceAssignmentType>>? =
        null

    private var securitySettingsName: Output<String>? = null

    /**
     * @param value The name of the cluster.
     */
    @JvmName("hckitqvnadbqfjdg")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mjmgnhgqnijfhbjv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Secured Core Compliance Assignment
     */
    @JvmName("nutixvhoqibdnbht")
    public suspend fun securedCoreComplianceAssignment(`value`: Output<Either<String, ComplianceAssignmentType>>) {
        this.securedCoreComplianceAssignment = value
    }

    /**
     * @param value Name of security setting
     */
    @JvmName("vafjesxququbtgal")
    public suspend fun securitySettingsName(`value`: Output<String>) {
        this.securitySettingsName = value
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("kuabrvdnlvyikdkh")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("phjrpustwrepvklk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Secured Core Compliance Assignment
     */
    @JvmName("ovadomttccytagbn")
    public suspend fun securedCoreComplianceAssignment(`value`: Either<String, ComplianceAssignmentType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securedCoreComplianceAssignment = mapped
    }

    /**
     * @param value Secured Core Compliance Assignment
     */
    @JvmName("rtloqaketavrxxaw")
    public fun securedCoreComplianceAssignment(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ComplianceAssignmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securedCoreComplianceAssignment = mapped
    }

    /**
     * @param value Secured Core Compliance Assignment
     */
    @JvmName("ablygdfjfyhuqfiv")
    public fun securedCoreComplianceAssignment(`value`: ComplianceAssignmentType) {
        val toBeMapped = Either.ofRight<String, ComplianceAssignmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securedCoreComplianceAssignment = mapped
    }

    /**
     * @param value Name of security setting
     */
    @JvmName("lctlurkqberulrjh")
    public suspend fun securitySettingsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securitySettingsName = mapped
    }

    internal fun build(): SecuritySettingArgs = SecuritySettingArgs(
        clusterName = clusterName,
        resourceGroupName = resourceGroupName,
        securedCoreComplianceAssignment = securedCoreComplianceAssignment,
        securitySettingsName = securitySettingsName,
    )
}
