@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualHardDiskStatusResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualHardDiskStatusResponse.Companion.toKotlin as virtualHardDiskStatusResponseToKotlin

/**
 * Builder for [VirtualHardDisk].
 */
@PulumiTagMarker
public class VirtualHardDiskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualHardDiskArgs = VirtualHardDiskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualHardDiskArgsBuilder.() -> Unit) {
        val builder = VirtualHardDiskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualHardDisk {
        val builtJavaResource =
            com.pulumi.azurenative.azurestackhci.VirtualHardDisk(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualHardDisk(builtJavaResource)
    }
}

/**
 * The virtual hard disk resource definition.
 * Azure REST API version: 2022-12-15-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2024-01-01.
 * ## Example Usage
 * ### PutVirtualHardDisk
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualHardDisk = new AzureNative.AzureStackHCI.VirtualHardDisk("virtualHardDisk", new()
 *     {
 *         DiskSizeGB = 32,
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = AzureNative.AzureStackHCI.ExtendedLocationTypes.CustomLocation,
 *         },
 *         Location = "West US2",
 *         ResourceGroupName = "test-rg",
 *         VirtualHardDiskName = "test-vhd",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewVirtualHardDisk(ctx, "virtualHardDisk", &azurestackhci.VirtualHardDiskArgs{
 * 			DiskSizeGB: pulumi.Float64(32),
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String(azurestackhci.ExtendedLocationTypesCustomLocation),
 * 			},
 * 			Location:            pulumi.String("West US2"),
 * 			ResourceGroupName:   pulumi.String("test-rg"),
 * 			VirtualHardDiskName: pulumi.String("test-vhd"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.VirtualHardDisk;
 * import com.pulumi.azurenative.azurestackhci.VirtualHardDiskArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualHardDisk = new VirtualHardDisk("virtualHardDisk", VirtualHardDiskArgs.builder()
 *             .diskSizeGB(32)
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("West US2")
 *             .resourceGroupName("test-rg")
 *             .virtualHardDiskName("test-vhd")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:VirtualHardDisk test-vhd /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/virtualHardDisks/{virtualHardDiskName}
 * ```
 */
public class VirtualHardDisk internal constructor(
    override val javaResource: com.pulumi.azurenative.azurestackhci.VirtualHardDisk,
) : KotlinCustomResource(javaResource, VirtualHardDiskMapper) {
    public val blockSizeBytes: Output<Int>?
        get() = javaResource.blockSizeBytes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Storage ContainerID of the storage container to be used for VHD
     */
    public val containerId: Output<String>?
        get() = javaResource.containerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The format of the actual VHD file [vhd, vhdx]
     */
    public val diskFileFormat: Output<String>?
        get() = javaResource.diskFileFormat().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Size of the disk in GB
     */
    public val diskSizeGB: Output<Double>?
        get() = javaResource.diskSizeGB().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Boolean for enabling dynamic sizing on the virtual hard disk
     */
    public val `dynamic`: Output<Boolean>?
        get() = javaResource.`dynamic`().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The extendedLocation of the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The hypervisor generation of the Virtual Machine [V1, V2]
     */
    public val hyperVGeneration: Output<String>?
        get() = javaResource.hyperVGeneration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    public val logicalSectorBytes: Output<Int>?
        get() = javaResource.logicalSectorBytes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val physicalSectorBytes: Output<Int>?
        get() = javaResource.physicalSectorBytes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provisioning state of the virtual hard disk.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The observed state of virtual hard disks
     */
    public val status: Output<VirtualHardDiskStatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                virtualHardDiskStatusResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VirtualHardDiskMapper : ResourceMapper<VirtualHardDisk> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurestackhci.VirtualHardDisk::class == javaResource::class

    override fun map(javaResource: Resource): VirtualHardDisk = VirtualHardDisk(
        javaResource as
            com.pulumi.azurenative.azurestackhci.VirtualHardDisk,
    )
}

/**
 * @see [VirtualHardDisk].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualHardDisk].
 */
public suspend fun virtualHardDisk(
    name: String,
    block: suspend VirtualHardDiskResourceBuilder.() -> Unit,
): VirtualHardDisk {
    val builder = VirtualHardDiskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualHardDisk].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualHardDisk(name: String): VirtualHardDisk {
    val builder = VirtualHardDiskResourceBuilder()
    builder.name(name)
    return builder.build()
}
