@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GuestAgentInstallStatusResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseHardwareProfile
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseNetworkProfile
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseOsProfile
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseSecurityProfile
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseStorageProfile
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstanceStatusResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstanceViewResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GuestAgentInstallStatusResponse.Companion.toKotlin as guestAgentInstallStatusResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseHardwareProfile.Companion.toKotlin as virtualMachineInstancePropertiesResponseHardwareProfileToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseNetworkProfile.Companion.toKotlin as virtualMachineInstancePropertiesResponseNetworkProfileToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseOsProfile.Companion.toKotlin as virtualMachineInstancePropertiesResponseOsProfileToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseSecurityProfile.Companion.toKotlin as virtualMachineInstancePropertiesResponseSecurityProfileToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseStorageProfile.Companion.toKotlin as virtualMachineInstancePropertiesResponseStorageProfileToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstanceStatusResponse.Companion.toKotlin as virtualMachineInstanceStatusResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstanceViewResponse.Companion.toKotlin as virtualMachineInstanceViewResponseToKotlin

/**
 * Builder for [VirtualMachineInstance].
 */
@PulumiTagMarker
public class VirtualMachineInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMachineInstanceArgs = VirtualMachineInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualMachineInstanceArgsBuilder.() -> Unit) {
        val builder = VirtualMachineInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualMachineInstance {
        val builtJavaResource =
            com.pulumi.azurenative.azurestackhci.VirtualMachineInstance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualMachineInstance(builtJavaResource)
    }
}

/**
 * The virtual machine instance resource definition.
 * Azure REST API version: 2023-07-01-preview.
 * Other available API versions: 2023-09-01-preview, 2024-01-01.
 * ## Example Usage
 * ### PutVirtualMachineInstanceWithGalleryImage
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineInstance = new AzureNative.AzureStackHCI.VirtualMachineInstance("virtualMachineInstance", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = AzureNative.AzureStackHCI.ExtendedLocationTypes.CustomLocation,
 *         },
 *         HardwareProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesHardwareProfileArgs
 *         {
 *             VmSize = AzureNative.AzureStackHCI.VmSizeEnum.Default,
 *         },
 *         NetworkProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesNetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesNetworkInterfacesArgs
 *                 {
 *                     Id = "test-nic",
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesOsProfileArgs
 *         {
 *             AdminPassword = "password",
 *             AdminUsername = "localadmin",
 *             ComputerName = "luamaster",
 *         },
 *         ResourceUri = "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM",
 *         SecurityProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesSecurityProfileArgs
 *         {
 *             EnableTPM = true,
 *             UefiSettings = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesUefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesStorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesImageReferenceArgs
 *             {
 *                 Id = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image",
 *             },
 *             VmConfigStoragePathId = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewVirtualMachineInstance(ctx, "virtualMachineInstance", &azurestackhci.VirtualMachineInstanceArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String(azurestackhci.ExtendedLocationTypesCustomLocation),
 * 			},
 * 			HardwareProfile: &azurestackhci.VirtualMachineInstancePropertiesHardwareProfileArgs{
 * 				VmSize: pulumi.String(azurestackhci.VmSizeEnumDefault),
 * 			},
 * 			NetworkProfile: &azurestackhci.VirtualMachineInstancePropertiesNetworkProfileArgs{
 * 				NetworkInterfaces: azurestackhci.VirtualMachineInstancePropertiesNetworkInterfacesArray{
 * 					&azurestackhci.VirtualMachineInstancePropertiesNetworkInterfacesArgs{
 * 						Id: pulumi.String("test-nic"),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &azurestackhci.VirtualMachineInstancePropertiesOsProfileArgs{
 * 				AdminPassword: pulumi.String("password"),
 * 				AdminUsername: pulumi.String("localadmin"),
 * 				ComputerName:  pulumi.String("luamaster"),
 * 			},
 * 			ResourceUri: pulumi.String("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM"),
 * 			SecurityProfile: &azurestackhci.VirtualMachineInstancePropertiesSecurityProfileArgs{
 * 				EnableTPM: pulumi.Bool(true),
 * 				UefiSettings: &azurestackhci.VirtualMachineInstancePropertiesUefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: &azurestackhci.VirtualMachineInstancePropertiesStorageProfileArgs{
 * 				ImageReference: &azurestackhci.VirtualMachineInstancePropertiesImageReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image"),
 * 				},
 * 				VmConfigStoragePathId: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineInstance;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineInstanceArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesHardwareProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesNetworkProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesOsProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesSecurityProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesUefiSettingsArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesStorageProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesImageReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineInstance = new VirtualMachineInstance("virtualMachineInstance", VirtualMachineInstanceArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location")
 *                 .type("CustomLocation")
 *                 .build())
 *             .hardwareProfile(VirtualMachineInstancePropertiesHardwareProfileArgs.builder()
 *                 .vmSize("Default")
 *                 .build())
 *             .networkProfile(VirtualMachineInstancePropertiesNetworkProfileArgs.builder()
 *                 .networkInterfaces(VirtualMachineInstancePropertiesNetworkInterfacesArgs.builder()
 *                     .id("test-nic")
 *                     .build())
 *                 .build())
 *             .osProfile(VirtualMachineInstancePropertiesOsProfileArgs.builder()
 *                 .adminPassword("password")
 *                 .adminUsername("localadmin")
 *                 .computerName("luamaster")
 *                 .build())
 *             .resourceUri("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM")
 *             .securityProfile(VirtualMachineInstancePropertiesSecurityProfileArgs.builder()
 *                 .enableTPM(true)
 *                 .uefiSettings(VirtualMachineInstancePropertiesUefiSettingsArgs.builder()
 *                     .secureBootEnabled(true)
 *                     .build())
 *                 .build())
 *             .storageProfile(VirtualMachineInstancePropertiesStorageProfileArgs.builder()
 *                 .imageReference(VirtualMachineInstancePropertiesImageReferenceArgs.builder()
 *                     .id("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image")
 *                     .build())
 *                 .vmConfigStoragePathId("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### PutVirtualMachineInstanceWithMarketplaceGalleryImage
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineInstance = new AzureNative.AzureStackHCI.VirtualMachineInstance("virtualMachineInstance", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = AzureNative.AzureStackHCI.ExtendedLocationTypes.CustomLocation,
 *         },
 *         HardwareProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesHardwareProfileArgs
 *         {
 *             VmSize = AzureNative.AzureStackHCI.VmSizeEnum.Default,
 *         },
 *         NetworkProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesNetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesNetworkInterfacesArgs
 *                 {
 *                     Id = "test-nic",
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesOsProfileArgs
 *         {
 *             AdminPassword = "password",
 *             AdminUsername = "localadmin",
 *             ComputerName = "luamaster",
 *         },
 *         ResourceUri = "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM",
 *         SecurityProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesSecurityProfileArgs
 *         {
 *             EnableTPM = true,
 *             UefiSettings = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesUefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesStorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesImageReferenceArgs
 *             {
 *                 Id = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/marketplaceGalleryImages/test-marketplace-gallery-image",
 *             },
 *             VmConfigStoragePathId = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewVirtualMachineInstance(ctx, "virtualMachineInstance", &azurestackhci.VirtualMachineInstanceArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String(azurestackhci.ExtendedLocationTypesCustomLocation),
 * 			},
 * 			HardwareProfile: &azurestackhci.VirtualMachineInstancePropertiesHardwareProfileArgs{
 * 				VmSize: pulumi.String(azurestackhci.VmSizeEnumDefault),
 * 			},
 * 			NetworkProfile: &azurestackhci.VirtualMachineInstancePropertiesNetworkProfileArgs{
 * 				NetworkInterfaces: azurestackhci.VirtualMachineInstancePropertiesNetworkInterfacesArray{
 * 					&azurestackhci.VirtualMachineInstancePropertiesNetworkInterfacesArgs{
 * 						Id: pulumi.String("test-nic"),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &azurestackhci.VirtualMachineInstancePropertiesOsProfileArgs{
 * 				AdminPassword: pulumi.String("password"),
 * 				AdminUsername: pulumi.String("localadmin"),
 * 				ComputerName:  pulumi.String("luamaster"),
 * 			},
 * 			ResourceUri: pulumi.String("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM"),
 * 			SecurityProfile: &azurestackhci.VirtualMachineInstancePropertiesSecurityProfileArgs{
 * 				EnableTPM: pulumi.Bool(true),
 * 				UefiSettings: &azurestackhci.VirtualMachineInstancePropertiesUefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: &azurestackhci.VirtualMachineInstancePropertiesStorageProfileArgs{
 * 				ImageReference: &azurestackhci.VirtualMachineInstancePropertiesImageReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/marketplaceGalleryImages/test-marketplace-gallery-image"),
 * 				},
 * 				VmConfigStoragePathId: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineInstance;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineInstanceArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesHardwareProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesNetworkProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesOsProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesSecurityProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesUefiSettingsArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesStorageProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesImageReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineInstance = new VirtualMachineInstance("virtualMachineInstance", VirtualMachineInstanceArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location")
 *                 .type("CustomLocation")
 *                 .build())
 *             .hardwareProfile(VirtualMachineInstancePropertiesHardwareProfileArgs.builder()
 *                 .vmSize("Default")
 *                 .build())
 *             .networkProfile(VirtualMachineInstancePropertiesNetworkProfileArgs.builder()
 *                 .networkInterfaces(VirtualMachineInstancePropertiesNetworkInterfacesArgs.builder()
 *                     .id("test-nic")
 *                     .build())
 *                 .build())
 *             .osProfile(VirtualMachineInstancePropertiesOsProfileArgs.builder()
 *                 .adminPassword("password")
 *                 .adminUsername("localadmin")
 *                 .computerName("luamaster")
 *                 .build())
 *             .resourceUri("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM")
 *             .securityProfile(VirtualMachineInstancePropertiesSecurityProfileArgs.builder()
 *                 .enableTPM(true)
 *                 .uefiSettings(VirtualMachineInstancePropertiesUefiSettingsArgs.builder()
 *                     .secureBootEnabled(true)
 *                     .build())
 *                 .build())
 *             .storageProfile(VirtualMachineInstancePropertiesStorageProfileArgs.builder()
 *                 .imageReference(VirtualMachineInstancePropertiesImageReferenceArgs.builder()
 *                     .id("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/marketplaceGalleryImages/test-marketplace-gallery-image")
 *                     .build())
 *                 .vmConfigStoragePathId("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### PutVirtualMachineInstanceWithOsDisk
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineInstance = new AzureNative.AzureStackHCI.VirtualMachineInstance("virtualMachineInstance", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = AzureNative.AzureStackHCI.ExtendedLocationTypes.CustomLocation,
 *         },
 *         HardwareProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesHardwareProfileArgs
 *         {
 *             VmSize = AzureNative.AzureStackHCI.VmSizeEnum.Default,
 *         },
 *         NetworkProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesNetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesNetworkInterfacesArgs
 *                 {
 *                     Id = "test-nic",
 *                 },
 *             },
 *         },
 *         ResourceUri = "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM",
 *         SecurityProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesSecurityProfileArgs
 *         {
 *             EnableTPM = true,
 *             UefiSettings = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesUefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesStorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesOsDiskArgs
 *             {
 *                 Id = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/virtualHardDisks/test-vhd",
 *             },
 *             VmConfigStoragePathId = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewVirtualMachineInstance(ctx, "virtualMachineInstance", &azurestackhci.VirtualMachineInstanceArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String(azurestackhci.ExtendedLocationTypesCustomLocation),
 * 			},
 * 			HardwareProfile: &azurestackhci.VirtualMachineInstancePropertiesHardwareProfileArgs{
 * 				VmSize: pulumi.String(azurestackhci.VmSizeEnumDefault),
 * 			},
 * 			NetworkProfile: &azurestackhci.VirtualMachineInstancePropertiesNetworkProfileArgs{
 * 				NetworkInterfaces: azurestackhci.VirtualMachineInstancePropertiesNetworkInterfacesArray{
 * 					&azurestackhci.VirtualMachineInstancePropertiesNetworkInterfacesArgs{
 * 						Id: pulumi.String("test-nic"),
 * 					},
 * 				},
 * 			},
 * 			ResourceUri: pulumi.String("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM"),
 * 			SecurityProfile: &azurestackhci.VirtualMachineInstancePropertiesSecurityProfileArgs{
 * 				EnableTPM: pulumi.Bool(true),
 * 				UefiSettings: &azurestackhci.VirtualMachineInstancePropertiesUefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: &azurestackhci.VirtualMachineInstancePropertiesStorageProfileArgs{
 * 				OsDisk: &azurestackhci.VirtualMachineInstancePropertiesOsDiskArgs{
 * 					Id: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/virtualHardDisks/test-vhd"),
 * 				},
 * 				VmConfigStoragePathId: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineInstance;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineInstanceArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesHardwareProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesNetworkProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesSecurityProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesUefiSettingsArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesStorageProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesOsDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineInstance = new VirtualMachineInstance("virtualMachineInstance", VirtualMachineInstanceArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location")
 *                 .type("CustomLocation")
 *                 .build())
 *             .hardwareProfile(VirtualMachineInstancePropertiesHardwareProfileArgs.builder()
 *                 .vmSize("Default")
 *                 .build())
 *             .networkProfile(VirtualMachineInstancePropertiesNetworkProfileArgs.builder()
 *                 .networkInterfaces(VirtualMachineInstancePropertiesNetworkInterfacesArgs.builder()
 *                     .id("test-nic")
 *                     .build())
 *                 .build())
 *             .resourceUri("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM")
 *             .securityProfile(VirtualMachineInstancePropertiesSecurityProfileArgs.builder()
 *                 .enableTPM(true)
 *                 .uefiSettings(VirtualMachineInstancePropertiesUefiSettingsArgs.builder()
 *                     .secureBootEnabled(true)
 *                     .build())
 *                 .build())
 *             .storageProfile(VirtualMachineInstancePropertiesStorageProfileArgs.builder()
 *                 .osDisk(VirtualMachineInstancePropertiesOsDiskArgs.builder()
 *                     .id("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/virtualHardDisks/test-vhd")
 *                     .build())
 *                 .vmConfigStoragePathId("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### PutVirtualMachineInstanceWithVMConfigAgent
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineInstance = new AzureNative.AzureStackHCI.VirtualMachineInstance("virtualMachineInstance", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = AzureNative.AzureStackHCI.ExtendedLocationTypes.CustomLocation,
 *         },
 *         HardwareProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesHardwareProfileArgs
 *         {
 *             VmSize = AzureNative.AzureStackHCI.VmSizeEnum.Default,
 *         },
 *         NetworkProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesNetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesNetworkInterfacesArgs
 *                 {
 *                     Id = "test-nic",
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesOsProfileArgs
 *         {
 *             AdminPassword = "password",
 *             AdminUsername = "localadmin",
 *             ComputerName = "luamaster",
 *             WindowsConfiguration = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesWindowsConfigurationArgs
 *             {
 *                 ProvisionVMConfigAgent = true,
 *             },
 *         },
 *         ResourceUri = "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM",
 *         SecurityProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesSecurityProfileArgs
 *         {
 *             EnableTPM = true,
 *             UefiSettings = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesUefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesStorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesImageReferenceArgs
 *             {
 *                 Id = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image",
 *             },
 *             VmConfigStoragePathId = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewVirtualMachineInstance(ctx, "virtualMachineInstance", &azurestackhci.VirtualMachineInstanceArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String(azurestackhci.ExtendedLocationTypesCustomLocation),
 * 			},
 * 			HardwareProfile: &azurestackhci.VirtualMachineInstancePropertiesHardwareProfileArgs{
 * 				VmSize: pulumi.String(azurestackhci.VmSizeEnumDefault),
 * 			},
 * 			NetworkProfile: &azurestackhci.VirtualMachineInstancePropertiesNetworkProfileArgs{
 * 				NetworkInterfaces: azurestackhci.VirtualMachineInstancePropertiesNetworkInterfacesArray{
 * 					&azurestackhci.VirtualMachineInstancePropertiesNetworkInterfacesArgs{
 * 						Id: pulumi.String("test-nic"),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &azurestackhci.VirtualMachineInstancePropertiesOsProfileArgs{
 * 				AdminPassword: pulumi.String("password"),
 * 				AdminUsername: pulumi.String("localadmin"),
 * 				ComputerName:  pulumi.String("luamaster"),
 * 				WindowsConfiguration: &azurestackhci.VirtualMachineInstancePropertiesWindowsConfigurationArgs{
 * 					ProvisionVMConfigAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceUri: pulumi.String("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM"),
 * 			SecurityProfile: &azurestackhci.VirtualMachineInstancePropertiesSecurityProfileArgs{
 * 				EnableTPM: pulumi.Bool(true),
 * 				UefiSettings: &azurestackhci.VirtualMachineInstancePropertiesUefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: &azurestackhci.VirtualMachineInstancePropertiesStorageProfileArgs{
 * 				ImageReference: &azurestackhci.VirtualMachineInstancePropertiesImageReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image"),
 * 				},
 * 				VmConfigStoragePathId: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineInstance;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineInstanceArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesHardwareProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesNetworkProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesOsProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesWindowsConfigurationArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesSecurityProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesUefiSettingsArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesStorageProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesImageReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineInstance = new VirtualMachineInstance("virtualMachineInstance", VirtualMachineInstanceArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location")
 *                 .type("CustomLocation")
 *                 .build())
 *             .hardwareProfile(VirtualMachineInstancePropertiesHardwareProfileArgs.builder()
 *                 .vmSize("Default")
 *                 .build())
 *             .networkProfile(VirtualMachineInstancePropertiesNetworkProfileArgs.builder()
 *                 .networkInterfaces(VirtualMachineInstancePropertiesNetworkInterfacesArgs.builder()
 *                     .id("test-nic")
 *                     .build())
 *                 .build())
 *             .osProfile(VirtualMachineInstancePropertiesOsProfileArgs.builder()
 *                 .adminPassword("password")
 *                 .adminUsername("localadmin")
 *                 .computerName("luamaster")
 *                 .windowsConfiguration(VirtualMachineInstancePropertiesWindowsConfigurationArgs.builder()
 *                     .provisionVMConfigAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceUri("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM")
 *             .securityProfile(VirtualMachineInstancePropertiesSecurityProfileArgs.builder()
 *                 .enableTPM(true)
 *                 .uefiSettings(VirtualMachineInstancePropertiesUefiSettingsArgs.builder()
 *                     .secureBootEnabled(true)
 *                     .build())
 *                 .build())
 *             .storageProfile(VirtualMachineInstancePropertiesStorageProfileArgs.builder()
 *                 .imageReference(VirtualMachineInstancePropertiesImageReferenceArgs.builder()
 *                     .id("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image")
 *                     .build())
 *                 .vmConfigStoragePathId("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:VirtualMachineInstance myresource1 /{resourceUri}/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default
 * ```
 */
public class VirtualMachineInstance internal constructor(
    override val javaResource: com.pulumi.azurenative.azurestackhci.VirtualMachineInstance,
) : KotlinCustomResource(javaResource, VirtualMachineInstanceMapper) {
    /**
     * The extendedLocation of the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Guest agent install status.
     */
    public val guestAgentInstallStatus: Output<GuestAgentInstallStatusResponse>?
        get() = javaResource.guestAgentInstallStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> guestAgentInstallStatusResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * HardwareProfile - Specifies the hardware settings for the virtual machine instance.
     */
    public val hardwareProfile: Output<VirtualMachineInstancePropertiesResponseHardwareProfile>?
        get() = javaResource.hardwareProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachineInstancePropertiesResponseHardwareProfileToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Identity for the resource.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The virtual machine instance view.
     */
    public val instanceView: Output<VirtualMachineInstanceViewResponse>
        get() = javaResource.instanceView().applyValue({ args0 ->
            args0.let({ args0 ->
                virtualMachineInstanceViewResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * NetworkProfile - describes the network configuration the virtual machine instance
     */
    public val networkProfile: Output<VirtualMachineInstancePropertiesResponseNetworkProfile>?
        get() = javaResource.networkProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachineInstancePropertiesResponseNetworkProfileToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * OsProfile - describes the configuration of the operating system and sets login data
     */
    public val osProfile: Output<VirtualMachineInstancePropertiesResponseOsProfile>?
        get() = javaResource.osProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachineInstancePropertiesResponseOsProfileToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Provisioning state of the virtual machine instance.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Unique identifier defined by ARC to identify the guest of the VM.
     */
    public val resourceUid: Output<String>?
        get() = javaResource.resourceUid().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * SecurityProfile - Specifies the security settings for the virtual machine instance.
     */
    public val securityProfile: Output<VirtualMachineInstancePropertiesResponseSecurityProfile>?
        get() = javaResource.securityProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachineInstancePropertiesResponseSecurityProfileToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The observed state of virtual machine instances
     */
    public val status: Output<VirtualMachineInstanceStatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                virtualMachineInstanceStatusResponseToKotlin(args0)
            })
        })

    /**
     * StorageProfile - contains information about the disks and storage information for the virtual machine instance
     */
    public val storageProfile: Output<VirtualMachineInstancePropertiesResponseStorageProfile>?
        get() = javaResource.storageProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachineInstancePropertiesResponseStorageProfileToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Unique identifier for the vm resource.
     */
    public val vmId: Output<String>
        get() = javaResource.vmId().applyValue({ args0 -> args0 })
}

public object VirtualMachineInstanceMapper : ResourceMapper<VirtualMachineInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurestackhci.VirtualMachineInstance::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMachineInstance =
        VirtualMachineInstance(
            javaResource as
                com.pulumi.azurenative.azurestackhci.VirtualMachineInstance,
        )
}

/**
 * @see [VirtualMachineInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMachineInstance].
 */
public suspend fun virtualMachineInstance(
    name: String,
    block: suspend VirtualMachineInstanceResourceBuilder.() -> Unit,
): VirtualMachineInstance {
    val builder = VirtualMachineInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMachineInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMachineInstance(name: String): VirtualMachineInstance {
    val builder = VirtualMachineInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
