@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Secured Core Compliance Assignment
 */
public enum class ComplianceAssignmentType(
    public val javaValue: com.pulumi.azurenative.azurestackhci.enums.ComplianceAssignmentType,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.enums.ComplianceAssignmentType> {
    /**
     * Report on the state of the machine, but don't make changes.
     */
    Audit(com.pulumi.azurenative.azurestackhci.enums.ComplianceAssignmentType.Audit),

    /**
     * Applied to the machine. If it drifts, the local service inside the machine makes a correction at the next evaluation.
     */
    ApplyAndAutoCorrect(com.pulumi.azurenative.azurestackhci.enums.ComplianceAssignmentType.ApplyAndAutoCorrect),
    ;

    override fun toJava(): com.pulumi.azurenative.azurestackhci.enums.ComplianceAssignmentType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.enums.ComplianceAssignmentType): ComplianceAssignmentType =
            ComplianceAssignmentType.values().first { it.javaValue == javaType }
    }
}
