@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. Possible values are: **Windows,** **Linux.**
 */
public enum class OperatingSystemTypes(
    public val javaValue: com.pulumi.azurenative.azurestackhci.enums.OperatingSystemTypes,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.enums.OperatingSystemTypes> {
    Linux(com.pulumi.azurenative.azurestackhci.enums.OperatingSystemTypes.Linux),
    Windows(com.pulumi.azurenative.azurestackhci.enums.OperatingSystemTypes.Windows),
    ;

    override fun toJava(): com.pulumi.azurenative.azurestackhci.enums.OperatingSystemTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.enums.OperatingSystemTypes): OperatingSystemTypes = OperatingSystemTypes.values().first { it.javaValue == javaType }
    }
}
