@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.AdapterPropertyOverridesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The AdapterPropertyOverrides of a cluster.
 * @property jumboPacket This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
 * @property networkDirect This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
 * @property networkDirectTechnology This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation. Expected values are 'iWARP', 'RoCEv2', 'RoCE'
 */
public data class AdapterPropertyOverridesArgs(
    public val jumboPacket: Output<String>? = null,
    public val networkDirect: Output<String>? = null,
    public val networkDirectTechnology: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.AdapterPropertyOverridesArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.AdapterPropertyOverridesArgs =
        com.pulumi.azurenative.azurestackhci.inputs.AdapterPropertyOverridesArgs.builder()
            .jumboPacket(jumboPacket?.applyValue({ args0 -> args0 }))
            .networkDirect(networkDirect?.applyValue({ args0 -> args0 }))
            .networkDirectTechnology(networkDirectTechnology?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AdapterPropertyOverridesArgs].
 */
@PulumiTagMarker
public class AdapterPropertyOverridesArgsBuilder internal constructor() {
    private var jumboPacket: Output<String>? = null

    private var networkDirect: Output<String>? = null

    private var networkDirectTechnology: Output<String>? = null

    /**
     * @param value This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
     */
    @JvmName("sgfxnietqdlxejos")
    public suspend fun jumboPacket(`value`: Output<String>) {
        this.jumboPacket = value
    }

    /**
     * @param value This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
     */
    @JvmName("mnljydwqbglcywfy")
    public suspend fun networkDirect(`value`: Output<String>) {
        this.networkDirect = value
    }

    /**
     * @param value This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation. Expected values are 'iWARP', 'RoCEv2', 'RoCE'
     */
    @JvmName("jwiidfhqhgqrxhis")
    public suspend fun networkDirectTechnology(`value`: Output<String>) {
        this.networkDirectTechnology = value
    }

    /**
     * @param value This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
     */
    @JvmName("kbnjtcweqbjxdupa")
    public suspend fun jumboPacket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jumboPacket = mapped
    }

    /**
     * @param value This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
     */
    @JvmName("xsaqgdadvurgbrwq")
    public suspend fun networkDirect(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkDirect = mapped
    }

    /**
     * @param value This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation. Expected values are 'iWARP', 'RoCEv2', 'RoCE'
     */
    @JvmName("rkkbgyycqechdded")
    public suspend fun networkDirectTechnology(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkDirectTechnology = mapped
    }

    internal fun build(): AdapterPropertyOverridesArgs = AdapterPropertyOverridesArgs(
        jumboPacket = jumboPacket,
        networkDirect = networkDirect,
        networkDirectTechnology = networkDirectTechnology,
    )
}
