@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.GalleryImageIdentifierArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This is the gallery image definition identifier.
 * @property offer The name of the gallery image definition offer.
 * @property publisher The name of the gallery image definition publisher.
 * @property sku The name of the gallery image definition SKU.
 */
public data class GalleryImageIdentifierArgs(
    public val offer: Output<String>,
    public val publisher: Output<String>,
    public val sku: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.GalleryImageIdentifierArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.GalleryImageIdentifierArgs =
        com.pulumi.azurenative.azurestackhci.inputs.GalleryImageIdentifierArgs.builder()
            .offer(offer.applyValue({ args0 -> args0 }))
            .publisher(publisher.applyValue({ args0 -> args0 }))
            .sku(sku.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GalleryImageIdentifierArgs].
 */
@PulumiTagMarker
public class GalleryImageIdentifierArgsBuilder internal constructor() {
    private var offer: Output<String>? = null

    private var publisher: Output<String>? = null

    private var sku: Output<String>? = null

    /**
     * @param value The name of the gallery image definition offer.
     */
    @JvmName("fpgafsnwfgdyabms")
    public suspend fun offer(`value`: Output<String>) {
        this.offer = value
    }

    /**
     * @param value The name of the gallery image definition publisher.
     */
    @JvmName("mudafaqemaaqdvnl")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value The name of the gallery image definition SKU.
     */
    @JvmName("yqqkkeqwyhkwpohl")
    public suspend fun sku(`value`: Output<String>) {
        this.sku = value
    }

    /**
     * @param value The name of the gallery image definition offer.
     */
    @JvmName("cmgylxoivatpasvd")
    public suspend fun offer(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offer = mapped
    }

    /**
     * @param value The name of the gallery image definition publisher.
     */
    @JvmName("eknjxbasyeafmacl")
    public suspend fun publisher(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value The name of the gallery image definition SKU.
     */
    @JvmName("uwodsvbfiofowgyx")
    public suspend fun sku(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    internal fun build(): GalleryImageIdentifierArgs = GalleryImageIdentifierArgs(
        offer = offer ?: throw PulumiNullFieldException("offer"),
        publisher = publisher ?: throw PulumiNullFieldException("publisher"),
        sku = sku ?: throw PulumiNullFieldException("sku"),
    )
}
