@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.GetExtensionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arcSettingName The name of the proxy resource holding details of HCI ArcSetting information.
 * @property clusterName The name of the cluster.
 * @property extensionName The name of the machine extension.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetExtensionPlainArgs(
    public val arcSettingName: String,
    public val clusterName: String,
    public val extensionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.GetExtensionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.GetExtensionPlainArgs =
        com.pulumi.azurenative.azurestackhci.inputs.GetExtensionPlainArgs.builder()
            .arcSettingName(arcSettingName.let({ args0 -> args0 }))
            .clusterName(clusterName.let({ args0 -> args0 }))
            .extensionName(extensionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExtensionPlainArgs].
 */
@PulumiTagMarker
public class GetExtensionPlainArgsBuilder internal constructor() {
    private var arcSettingName: String? = null

    private var clusterName: String? = null

    private var extensionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the proxy resource holding details of HCI ArcSetting information.
     */
    @JvmName("axtfxlhoiwurawba")
    public suspend fun arcSettingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arcSettingName = mapped
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("osrwdsluppmpfexa")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the machine extension.
     */
    @JvmName("kyyftpdbsmofqyto")
    public suspend fun extensionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.extensionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lcclkcvfwmnsaoyy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetExtensionPlainArgs = GetExtensionPlainArgs(
        arcSettingName = arcSettingName ?: throw PulumiNullFieldException("arcSettingName"),
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        extensionName = extensionName ?: throw PulumiNullFieldException("extensionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
