@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.GetLogicalNetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property logicalNetworkName Name of the logical network
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetLogicalNetworkPlainArgs(
    public val logicalNetworkName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.GetLogicalNetworkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.GetLogicalNetworkPlainArgs =
        com.pulumi.azurenative.azurestackhci.inputs.GetLogicalNetworkPlainArgs.builder()
            .logicalNetworkName(logicalNetworkName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLogicalNetworkPlainArgs].
 */
@PulumiTagMarker
public class GetLogicalNetworkPlainArgsBuilder internal constructor() {
    private var logicalNetworkName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the logical network
     */
    @JvmName("hntglgovvfgybxdl")
    public suspend fun logicalNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.logicalNetworkName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hyepqbkrvtbouehd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLogicalNetworkPlainArgs = GetLogicalNetworkPlainArgs(
        logicalNetworkName = logicalNetworkName ?: throw PulumiNullFieldException("logicalNetworkName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
