@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.GetNetworkInterfacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkInterfaceName Name of the network interface
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNetworkInterfacePlainArgs(
    public val networkInterfaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.GetNetworkInterfacePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.GetNetworkInterfacePlainArgs =
        com.pulumi.azurenative.azurestackhci.inputs.GetNetworkInterfacePlainArgs.builder()
            .networkInterfaceName(networkInterfaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkInterfacePlainArgs].
 */
@PulumiTagMarker
public class GetNetworkInterfacePlainArgsBuilder internal constructor() {
    private var networkInterfaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the network interface
     */
    @JvmName("ijwttuxebtyjnrok")
    public suspend fun networkInterfaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkInterfaceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vskajhldyupvkeqq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkInterfacePlainArgs = GetNetworkInterfacePlainArgs(
        networkInterfaceName = networkInterfaceName ?: throw
            PulumiNullFieldException("networkInterfaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
