@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.GetStorageContainerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageContainerName Name of the storage container
 */
public data class GetStorageContainerPlainArgs(
    public val resourceGroupName: String,
    public val storageContainerName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.GetStorageContainerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.GetStorageContainerPlainArgs =
        com.pulumi.azurenative.azurestackhci.inputs.GetStorageContainerPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageContainerName(storageContainerName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStorageContainerPlainArgs].
 */
@PulumiTagMarker
public class GetStorageContainerPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var storageContainerName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vgpacvrqcatwxcje")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the storage container
     */
    @JvmName("dapdekxsdhbnxdna")
    public suspend fun storageContainerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageContainerName = mapped
    }

    internal fun build(): GetStorageContainerPlainArgs = GetStorageContainerPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        storageContainerName = storageContainerName ?: throw
            PulumiNullFieldException("storageContainerName"),
    )
}
