@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.GuestCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Username / Password Credentials to connect to guest.
 * @property password The password to connect with the guest.
 * @property username The username to connect with the guest.
 */
public data class GuestCredentialArgs(
    public val password: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.GuestCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.GuestCredentialArgs =
        com.pulumi.azurenative.azurestackhci.inputs.GuestCredentialArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GuestCredentialArgs].
 */
@PulumiTagMarker
public class GuestCredentialArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The password to connect with the guest.
     */
    @JvmName("tdvntfojpeevojqi")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The username to connect with the guest.
     */
    @JvmName("qpbuvydtcnvqrbyi")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The password to connect with the guest.
     */
    @JvmName("cfkbhwktdvymxltc")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The username to connect with the guest.
     */
    @JvmName("kncavjxhjyrbrdxv")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): GuestCredentialArgs = GuestCredentialArgs(
        password = password,
        username = username,
    )
}
