@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.IntentsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The Intents of a cluster.
 * @property adapter Array of network interfaces used for the network intent.
 * @property adapterPropertyOverrides Set Adapter PropertyOverrides for cluster.
 * @property name Name of the network intent you wish to create.
 * @property overrideAdapterProperty This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
 * @property overrideQosPolicy This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
 * @property overrideVirtualSwitchConfiguration This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
 * @property qosPolicyOverrides Set QoS PolicyOverrides for cluster.
 * @property trafficType List of network traffic types. Only allowed values are 'Compute', 'Storage', 'Management'.
 * @property virtualSwitchConfigurationOverrides Set virtualSwitch ConfigurationOverrides for cluster.
 */
public data class IntentsArgs(
    public val adapter: Output<List<String>>? = null,
    public val adapterPropertyOverrides: Output<AdapterPropertyOverridesArgs>? = null,
    public val name: Output<String>? = null,
    public val overrideAdapterProperty: Output<Boolean>? = null,
    public val overrideQosPolicy: Output<Boolean>? = null,
    public val overrideVirtualSwitchConfiguration: Output<Boolean>? = null,
    public val qosPolicyOverrides: Output<QosPolicyOverridesArgs>? = null,
    public val trafficType: Output<List<String>>? = null,
    public val virtualSwitchConfigurationOverrides: Output<VirtualSwitchConfigurationOverridesArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.IntentsArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.IntentsArgs =
        com.pulumi.azurenative.azurestackhci.inputs.IntentsArgs.builder()
            .adapter(adapter?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .adapterPropertyOverrides(
                adapterPropertyOverrides?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .overrideAdapterProperty(overrideAdapterProperty?.applyValue({ args0 -> args0 }))
            .overrideQosPolicy(overrideQosPolicy?.applyValue({ args0 -> args0 }))
            .overrideVirtualSwitchConfiguration(
                overrideVirtualSwitchConfiguration?.applyValue({ args0 ->
                    args0
                }),
            )
            .qosPolicyOverrides(
                qosPolicyOverrides?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .trafficType(trafficType?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .virtualSwitchConfigurationOverrides(
                virtualSwitchConfigurationOverrides?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [IntentsArgs].
 */
@PulumiTagMarker
public class IntentsArgsBuilder internal constructor() {
    private var adapter: Output<List<String>>? = null

    private var adapterPropertyOverrides: Output<AdapterPropertyOverridesArgs>? = null

    private var name: Output<String>? = null

    private var overrideAdapterProperty: Output<Boolean>? = null

    private var overrideQosPolicy: Output<Boolean>? = null

    private var overrideVirtualSwitchConfiguration: Output<Boolean>? = null

    private var qosPolicyOverrides: Output<QosPolicyOverridesArgs>? = null

    private var trafficType: Output<List<String>>? = null

    private var virtualSwitchConfigurationOverrides: Output<VirtualSwitchConfigurationOverridesArgs>? =
        null

    /**
     * @param value Array of network interfaces used for the network intent.
     */
    @JvmName("debniyhkwjngicik")
    public suspend fun adapter(`value`: Output<List<String>>) {
        this.adapter = value
    }

    @JvmName("axsntdrycrxbdhtp")
    public suspend fun adapter(vararg values: Output<String>) {
        this.adapter = Output.all(values.asList())
    }

    /**
     * @param values Array of network interfaces used for the network intent.
     */
    @JvmName("sdodihxqbyhlwypj")
    public suspend fun adapter(values: List<Output<String>>) {
        this.adapter = Output.all(values)
    }

    /**
     * @param value Set Adapter PropertyOverrides for cluster.
     */
    @JvmName("xykfxlxdwgueinsq")
    public suspend fun adapterPropertyOverrides(`value`: Output<AdapterPropertyOverridesArgs>) {
        this.adapterPropertyOverrides = value
    }

    /**
     * @param value Name of the network intent you wish to create.
     */
    @JvmName("gdkjvvscgjghugmn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
     */
    @JvmName("qttevfaiumkiarxv")
    public suspend fun overrideAdapterProperty(`value`: Output<Boolean>) {
        this.overrideAdapterProperty = value
    }

    /**
     * @param value This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
     */
    @JvmName("mtrvrmdvlhsxhdyt")
    public suspend fun overrideQosPolicy(`value`: Output<Boolean>) {
        this.overrideQosPolicy = value
    }

    /**
     * @param value This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
     */
    @JvmName("wxoouksyxeqskaic")
    public suspend fun overrideVirtualSwitchConfiguration(`value`: Output<Boolean>) {
        this.overrideVirtualSwitchConfiguration = value
    }

    /**
     * @param value Set QoS PolicyOverrides for cluster.
     */
    @JvmName("xgjkbmioolseaylr")
    public suspend fun qosPolicyOverrides(`value`: Output<QosPolicyOverridesArgs>) {
        this.qosPolicyOverrides = value
    }

    /**
     * @param value List of network traffic types. Only allowed values are 'Compute', 'Storage', 'Management'.
     */
    @JvmName("qpvvtpxvctvuqfac")
    public suspend fun trafficType(`value`: Output<List<String>>) {
        this.trafficType = value
    }

    @JvmName("xnejajcwxqeeduni")
    public suspend fun trafficType(vararg values: Output<String>) {
        this.trafficType = Output.all(values.asList())
    }

    /**
     * @param values List of network traffic types. Only allowed values are 'Compute', 'Storage', 'Management'.
     */
    @JvmName("gwpjnhkfvttvenyi")
    public suspend fun trafficType(values: List<Output<String>>) {
        this.trafficType = Output.all(values)
    }

    /**
     * @param value Set virtualSwitch ConfigurationOverrides for cluster.
     */
    @JvmName("wuxcntwlvwrytkod")
    public suspend fun virtualSwitchConfigurationOverrides(`value`: Output<VirtualSwitchConfigurationOverridesArgs>) {
        this.virtualSwitchConfigurationOverrides = value
    }

    /**
     * @param value Array of network interfaces used for the network intent.
     */
    @JvmName("jvcbbpsxxerldwep")
    public suspend fun adapter(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adapter = mapped
    }

    /**
     * @param values Array of network interfaces used for the network intent.
     */
    @JvmName("snvbxxovdgbklkgs")
    public suspend fun adapter(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adapter = mapped
    }

    /**
     * @param value Set Adapter PropertyOverrides for cluster.
     */
    @JvmName("qcvendiwmbphsgca")
    public suspend fun adapterPropertyOverrides(`value`: AdapterPropertyOverridesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adapterPropertyOverrides = mapped
    }

    /**
     * @param argument Set Adapter PropertyOverrides for cluster.
     */
    @JvmName("jsghaslqpjdtyorp")
    public suspend fun adapterPropertyOverrides(argument: suspend AdapterPropertyOverridesArgsBuilder.() -> Unit) {
        val toBeMapped = AdapterPropertyOverridesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.adapterPropertyOverrides = mapped
    }

    /**
     * @param value Name of the network intent you wish to create.
     */
    @JvmName("hxtsdnglwukssgfk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
     */
    @JvmName("rybcmvvoptifcwbi")
    public suspend fun overrideAdapterProperty(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrideAdapterProperty = mapped
    }

    /**
     * @param value This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
     */
    @JvmName("qdxygowgkxfnkjyq")
    public suspend fun overrideQosPolicy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrideQosPolicy = mapped
    }

    /**
     * @param value This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
     */
    @JvmName("tnworfdoebnilcmh")
    public suspend fun overrideVirtualSwitchConfiguration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrideVirtualSwitchConfiguration = mapped
    }

    /**
     * @param value Set QoS PolicyOverrides for cluster.
     */
    @JvmName("fbonacfyhvjdbdck")
    public suspend fun qosPolicyOverrides(`value`: QosPolicyOverridesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qosPolicyOverrides = mapped
    }

    /**
     * @param argument Set QoS PolicyOverrides for cluster.
     */
    @JvmName("ormuqoevdhxhmfqi")
    public suspend fun qosPolicyOverrides(argument: suspend QosPolicyOverridesArgsBuilder.() -> Unit) {
        val toBeMapped = QosPolicyOverridesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.qosPolicyOverrides = mapped
    }

    /**
     * @param value List of network traffic types. Only allowed values are 'Compute', 'Storage', 'Management'.
     */
    @JvmName("rvkbgfbbyhwomeec")
    public suspend fun trafficType(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficType = mapped
    }

    /**
     * @param values List of network traffic types. Only allowed values are 'Compute', 'Storage', 'Management'.
     */
    @JvmName("cvppvygmrnyvdvoe")
    public suspend fun trafficType(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trafficType = mapped
    }

    /**
     * @param value Set virtualSwitch ConfigurationOverrides for cluster.
     */
    @JvmName("wojjddhcufooqanp")
    public suspend fun virtualSwitchConfigurationOverrides(`value`: VirtualSwitchConfigurationOverridesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualSwitchConfigurationOverrides = mapped
    }

    /**
     * @param argument Set virtualSwitch ConfigurationOverrides for cluster.
     */
    @JvmName("onfmkkqhbqwwgnob")
    public suspend fun virtualSwitchConfigurationOverrides(argument: suspend VirtualSwitchConfigurationOverridesArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualSwitchConfigurationOverridesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.virtualSwitchConfigurationOverrides = mapped
    }

    internal fun build(): IntentsArgs = IntentsArgs(
        adapter = adapter,
        adapterPropertyOverrides = adapterPropertyOverrides,
        name = name,
        overrideAdapterProperty = overrideAdapterProperty,
        overrideQosPolicy = overrideQosPolicy,
        overrideVirtualSwitchConfiguration = overrideVirtualSwitchConfiguration,
        qosPolicyOverrides = qosPolicyOverrides,
        trafficType = trafficType,
        virtualSwitchConfigurationOverrides = virtualSwitchConfigurationOverrides,
    )
}
