@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.InterfaceDNSSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dnsServers List of DNS server IP Addresses for the interface
 */
public data class InterfaceDNSSettingsArgs(
    public val dnsServers: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.InterfaceDNSSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.InterfaceDNSSettingsArgs =
        com.pulumi.azurenative.azurestackhci.inputs.InterfaceDNSSettingsArgs.builder()
            .dnsServers(dnsServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [InterfaceDNSSettingsArgs].
 */
@PulumiTagMarker
public class InterfaceDNSSettingsArgsBuilder internal constructor() {
    private var dnsServers: Output<List<String>>? = null

    /**
     * @param value List of DNS server IP Addresses for the interface
     */
    @JvmName("tbgnyqyafnnfnklo")
    public suspend fun dnsServers(`value`: Output<List<String>>) {
        this.dnsServers = value
    }

    @JvmName("tydiqhtnwopannjr")
    public suspend fun dnsServers(vararg values: Output<String>) {
        this.dnsServers = Output.all(values.asList())
    }

    /**
     * @param values List of DNS server IP Addresses for the interface
     */
    @JvmName("likedpstlrdvhkly")
    public suspend fun dnsServers(values: List<Output<String>>) {
        this.dnsServers = Output.all(values)
    }

    /**
     * @param value List of DNS server IP Addresses for the interface
     */
    @JvmName("ibdrnqifimariiva")
    public suspend fun dnsServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param values List of DNS server IP Addresses for the interface
     */
    @JvmName("pibkwymashqhdwps")
    public suspend fun dnsServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    internal fun build(): InterfaceDNSSettingsArgs = InterfaceDNSSettingsArgs(
        dnsServers = dnsServers,
    )
}
