@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.LogicalNetworkPropertiesDhcpOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * DhcpOptions contains an array of DNS servers available to VMs deployed in the logical network. Standard DHCP option for a subnet overrides logical network DHCP options.
 * @property dnsServers The list of DNS servers IP addresses.
 */
public data class LogicalNetworkPropertiesDhcpOptionsArgs(
    public val dnsServers: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.LogicalNetworkPropertiesDhcpOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.LogicalNetworkPropertiesDhcpOptionsArgs =
        com.pulumi.azurenative.azurestackhci.inputs.LogicalNetworkPropertiesDhcpOptionsArgs.builder()
            .dnsServers(dnsServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [LogicalNetworkPropertiesDhcpOptionsArgs].
 */
@PulumiTagMarker
public class LogicalNetworkPropertiesDhcpOptionsArgsBuilder internal constructor() {
    private var dnsServers: Output<List<String>>? = null

    /**
     * @param value The list of DNS servers IP addresses.
     */
    @JvmName("otcggohgihnbwlji")
    public suspend fun dnsServers(`value`: Output<List<String>>) {
        this.dnsServers = value
    }

    @JvmName("gdwxbqvlmpwqqyxo")
    public suspend fun dnsServers(vararg values: Output<String>) {
        this.dnsServers = Output.all(values.asList())
    }

    /**
     * @param values The list of DNS servers IP addresses.
     */
    @JvmName("emfgqtkothogvgjs")
    public suspend fun dnsServers(values: List<Output<String>>) {
        this.dnsServers = Output.all(values)
    }

    /**
     * @param value The list of DNS servers IP addresses.
     */
    @JvmName("imqcfpcdtmvpdptb")
    public suspend fun dnsServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param values The list of DNS servers IP addresses.
     */
    @JvmName("qeaukdtqwajiwrqc")
    public suspend fun dnsServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    internal fun build(): LogicalNetworkPropertiesDhcpOptionsArgs =
        LogicalNetworkPropertiesDhcpOptionsArgs(
            dnsServers = dnsServers,
        )
}
