@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.SshPublicKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.
 * @property keyData SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
 * @property path Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
 */
public data class SshPublicKeyArgs(
    public val keyData: Output<String>? = null,
    public val path: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.SshPublicKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.SshPublicKeyArgs =
        com.pulumi.azurenative.azurestackhci.inputs.SshPublicKeyArgs.builder()
            .keyData(keyData?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SshPublicKeyArgs].
 */
@PulumiTagMarker
public class SshPublicKeyArgsBuilder internal constructor() {
    private var keyData: Output<String>? = null

    private var path: Output<String>? = null

    /**
     * @param value SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
     */
    @JvmName("ljqlvbsqpicaqfyn")
    public suspend fun keyData(`value`: Output<String>) {
        this.keyData = value
    }

    /**
     * @param value Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
     */
    @JvmName("ejpedieafkhglmgd")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
     */
    @JvmName("kikwvkpemlpnejqx")
    public suspend fun keyData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyData = mapped
    }

    /**
     * @param value Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
     */
    @JvmName("neeabuxitdhhbtwo")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): SshPublicKeyArgs = SshPublicKeyArgs(
        keyData = keyData,
        path = path,
    )
}
