@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesNetworkInterfacesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id ID - Resource Id of the network interface
 */
public data class VirtualMachineInstancePropertiesNetworkInterfacesArgs(
    public val id: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesNetworkInterfacesArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesNetworkInterfacesArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesNetworkInterfacesArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineInstancePropertiesNetworkInterfacesArgs].
 */
@PulumiTagMarker
public class VirtualMachineInstancePropertiesNetworkInterfacesArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value ID - Resource Id of the network interface
     */
    @JvmName("kkmxxayilyomlgjj")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value ID - Resource Id of the network interface
     */
    @JvmName("xbxokgmbfvnqencx")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): VirtualMachineInstancePropertiesNetworkInterfacesArgs =
        VirtualMachineInstancePropertiesNetworkInterfacesArgs(
            id = id,
        )
}
