@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesSshArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * SSH - contains settings related to ssh configuration
 * @property publicKeys PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
 */
public data class VirtualMachinePropertiesSshArgs(
    public val publicKeys: Output<List<VirtualMachinePropertiesPublicKeysArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesSshArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesSshArgs = com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesSshArgs.builder()
        .publicKeys(
            publicKeys?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        ).build()
}

/**
 * Builder for [VirtualMachinePropertiesSshArgs].
 */
@PulumiTagMarker
public class VirtualMachinePropertiesSshArgsBuilder internal constructor() {
    private var publicKeys: Output<List<VirtualMachinePropertiesPublicKeysArgs>>? = null

    /**
     * @param value PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("bigwqdgtooiawqnr")
    public suspend fun publicKeys(`value`: Output<List<VirtualMachinePropertiesPublicKeysArgs>>) {
        this.publicKeys = value
    }

    @JvmName("aqayamiudqpwtwhx")
    public suspend fun publicKeys(vararg values: Output<VirtualMachinePropertiesPublicKeysArgs>) {
        this.publicKeys = Output.all(values.asList())
    }

    /**
     * @param values PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("isvemvqetesnpksa")
    public suspend fun publicKeys(values: List<Output<VirtualMachinePropertiesPublicKeysArgs>>) {
        this.publicKeys = Output.all(values)
    }

    /**
     * @param value PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("gnvvxdbvfxmrnvnt")
    public suspend fun publicKeys(`value`: List<VirtualMachinePropertiesPublicKeysArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKeys = mapped
    }

    /**
     * @param argument PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("shulhtprohdgkdsu")
    public suspend fun publicKeys(argument: List<suspend VirtualMachinePropertiesPublicKeysArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachinePropertiesPublicKeysArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.publicKeys = mapped
    }

    /**
     * @param argument PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("fatbufwerdfloncr")
    public suspend fun publicKeys(vararg argument: suspend VirtualMachinePropertiesPublicKeysArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualMachinePropertiesPublicKeysArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.publicKeys = mapped
    }

    /**
     * @param argument PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("iotnoksowfkdgsoc")
    public suspend fun publicKeys(argument: suspend VirtualMachinePropertiesPublicKeysArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualMachinePropertiesPublicKeysArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.publicKeys = mapped
    }

    /**
     * @param values PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("sgbplxtwhbtfxkhy")
    public suspend fun publicKeys(vararg values: VirtualMachinePropertiesPublicKeysArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicKeys = mapped
    }

    internal fun build(): VirtualMachinePropertiesSshArgs = VirtualMachinePropertiesSshArgs(
        publicKeys = publicKeys,
    )
}
