@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The Deployment data of AzureStackHCI Cluster.
 * @property adouPath The path to the Active Directory Organizational Unit container object prepared for the deployment.
 * @property cluster Observability config to deploy AzureStackHCI Cluster.
 * @property domainFqdn FQDN to deploy cluster
 * @property hostNetwork HostNetwork config to deploy AzureStackHCI Cluster.
 * @property infrastructureNetwork InfrastructureNetwork config to deploy AzureStackHCI Cluster.
 * @property namingPrefix naming prefix to deploy cluster.
 * @property observability Observability config to deploy AzureStackHCI Cluster.
 * @property optionalServices OptionalServices config to deploy AzureStackHCI Cluster.
 * @property physicalNodes list of physical nodes config to deploy AzureStackHCI Cluster.
 * @property secretsLocation The URI to the keyvault / secret store.
 * @property securitySettings SecuritySettings to deploy AzureStackHCI Cluster.
 * @property storage Storage config to deploy AzureStackHCI Cluster.
 */
public data class DeploymentDataResponse(
    public val adouPath: String? = null,
    public val cluster: ClusterResponse? = null,
    public val domainFqdn: String? = null,
    public val hostNetwork: HostNetworkResponse? = null,
    public val infrastructureNetwork: List<InfrastructureNetworkResponse>? = null,
    public val namingPrefix: String? = null,
    public val observability: ObservabilityResponse? = null,
    public val optionalServices: OptionalServicesResponse? = null,
    public val physicalNodes: List<PhysicalNodesResponse>? = null,
    public val secretsLocation: String? = null,
    public val securitySettings: SecuritySettingsResponse? = null,
    public val storage: StorageResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.DeploymentDataResponse): DeploymentDataResponse = DeploymentDataResponse(
            adouPath = javaType.adouPath().map({ args0 -> args0 }).orElse(null),
            cluster = javaType.cluster().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.ClusterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            domainFqdn = javaType.domainFqdn().map({ args0 -> args0 }).orElse(null),
            hostNetwork = javaType.hostNetwork().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.HostNetworkResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            infrastructureNetwork = javaType.infrastructureNetwork().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.InfrastructureNetworkResponse.Companion.toKotlin(args0)
                })
            }),
            namingPrefix = javaType.namingPrefix().map({ args0 -> args0 }).orElse(null),
            observability = javaType.observability().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.ObservabilityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            optionalServices = javaType.optionalServices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.OptionalServicesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            physicalNodes = javaType.physicalNodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.PhysicalNodesResponse.Companion.toKotlin(args0)
                })
            }),
            secretsLocation = javaType.secretsLocation().map({ args0 -> args0 }).orElse(null),
            securitySettings = javaType.securitySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.SecuritySettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storage = javaType.storage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.StorageResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
