@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The device Configuration of a device.
 * @property deviceMetadata device metadata details.
 * @property nicDetails NIC Details of device
 */
public data class DeviceConfigurationResponse(
    public val deviceMetadata: String? = null,
    public val nicDetails: List<NicDetailResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.DeviceConfigurationResponse): DeviceConfigurationResponse = DeviceConfigurationResponse(
            deviceMetadata = javaType.deviceMetadata().map({ args0 -> args0 }).orElse(null),
            nicDetails = javaType.nicDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.NicDetailResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
