@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the Extension Instance View.
 * @property name The extension name.
 * @property status Instance view status.
 * @property type Specifies the type of the extension; an example is "MicrosoftMonitoringAgent".
 * @property typeHandlerVersion Specifies the version of the script handler.
 */
public data class ExtensionInstanceViewResponse(
    public val name: String? = null,
    public val status: ExtensionInstanceViewResponseStatus? = null,
    public val type: String? = null,
    public val typeHandlerVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.ExtensionInstanceViewResponse): ExtensionInstanceViewResponse = ExtensionInstanceViewResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtensionInstanceViewResponseStatus.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            typeHandlerVersion = javaType.typeHandlerVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
