@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Details of a particular extension in HCI Cluster.
 * @property aggregateState Aggregate state of Arc Extensions across the nodes in this HCI cluster.
 * @property autoUpgradeMinorVersion Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
 * @property enableAutomaticUpgrade Indicates whether the extension should be automatically upgraded by the platform if there is a newer version available.
 * @property forceUpdateTag How the extension handler should be forced to update even if the extension configuration has not changed.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property managedBy Indicates if the extension is managed by azure or the user.
 * @property name The name of the resource
 * @property perNodeExtensionDetails State of Arc Extension in each of the nodes.
 * @property protectedSettings Protected settings (may contain secrets).
 * @property provisioningState Provisioning state of the Extension proxy resource.
 * @property publisher The name of the extension handler publisher.
 * @property settings Json formatted public settings for the extension.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property typeHandlerVersion Specifies the version of the script handler. Latest version would be used if not specified.
 */
public data class GetExtensionResult(
    public val aggregateState: String,
    public val autoUpgradeMinorVersion: Boolean? = null,
    public val enableAutomaticUpgrade: Boolean? = null,
    public val forceUpdateTag: String? = null,
    public val id: String,
    public val managedBy: String,
    public val name: String,
    public val perNodeExtensionDetails: List<PerNodeExtensionStateResponse>,
    public val protectedSettings: Any? = null,
    public val provisioningState: String,
    public val publisher: String? = null,
    public val settings: Any? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val typeHandlerVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.GetExtensionResult): GetExtensionResult = GetExtensionResult(
            aggregateState = javaType.aggregateState(),
            autoUpgradeMinorVersion = javaType.autoUpgradeMinorVersion().map({ args0 -> args0 }).orElse(null),
            enableAutomaticUpgrade = javaType.enableAutomaticUpgrade().map({ args0 -> args0 }).orElse(null),
            forceUpdateTag = javaType.forceUpdateTag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            managedBy = javaType.managedBy(),
            name = javaType.name(),
            perNodeExtensionDetails = javaType.perNodeExtensionDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.PerNodeExtensionStateResponse.Companion.toKotlin(args0)
                })
            }),
            protectedSettings = javaType.protectedSettings().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
            settings = javaType.settings().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            typeHandlerVersion = javaType.typeHandlerVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
