@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Security settings proxy resource
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState The status of the last operation.
 * @property securedCoreComplianceAssignment Secured Core Compliance Assignment
 * @property securityComplianceStatus Security Compliance Status
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSecuritySettingResult(
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val securedCoreComplianceAssignment: String? = null,
    public val securityComplianceStatus: SecurityComplianceStatusResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.GetSecuritySettingResult): GetSecuritySettingResult = GetSecuritySettingResult(
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            securedCoreComplianceAssignment = javaType.securedCoreComplianceAssignment().map({ args0 ->
                args0
            }).orElse(null),
            securityComplianceStatus = javaType.securityComplianceStatus().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.SecurityComplianceStatusResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
