@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The virtual hard disk resource definition.
 * @property blockSizeBytes
 * @property containerId Storage ContainerID of the storage container to be used for VHD
 * @property diskFileFormat The format of the actual VHD file [vhd, vhdx]
 * @property diskSizeGB Size of the disk in GB
 * @property dynamic Boolean for enabling dynamic sizing on the virtual hard disk
 * @property extendedLocation The extendedLocation of the resource.
 * @property hyperVGeneration The hypervisor generation of the Virtual Machine [V1, V2]
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property logicalSectorBytes
 * @property name The name of the resource
 * @property physicalSectorBytes
 * @property provisioningState Provisioning state of the virtual hard disk.
 * @property status The observed state of virtual hard disks
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetVirtualHardDiskResult(
    public val blockSizeBytes: Int? = null,
    public val containerId: String? = null,
    public val diskFileFormat: String? = null,
    public val diskSizeGB: Double? = null,
    public val `dynamic`: Boolean? = null,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val hyperVGeneration: String? = null,
    public val id: String,
    public val location: String,
    public val logicalSectorBytes: Int? = null,
    public val name: String,
    public val physicalSectorBytes: Int? = null,
    public val provisioningState: String,
    public val status: VirtualHardDiskStatusResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.GetVirtualHardDiskResult): GetVirtualHardDiskResult = GetVirtualHardDiskResult(
            blockSizeBytes = javaType.blockSizeBytes().map({ args0 -> args0 }).orElse(null),
            containerId = javaType.containerId().map({ args0 -> args0 }).orElse(null),
            diskFileFormat = javaType.diskFileFormat().map({ args0 -> args0 }).orElse(null),
            diskSizeGB = javaType.diskSizeGB().map({ args0 -> args0 }).orElse(null),
            `dynamic` = javaType.`dynamic`().map({ args0 -> args0 }).orElse(null),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hyperVGeneration = javaType.hyperVGeneration().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            logicalSectorBytes = javaType.logicalSectorBytes().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            physicalSectorBytes = javaType.physicalSectorBytes().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualHardDiskStatusResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
