@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The virtual machine instance resource definition.
 * @property extendedLocation The extendedLocation of the resource.
 * @property guestAgentInstallStatus Guest agent install status.
 * @property hardwareProfile HardwareProfile - Specifies the hardware settings for the virtual machine instance.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity Identity for the resource.
 * @property instanceView The virtual machine instance view.
 * @property name The name of the resource
 * @property networkProfile NetworkProfile - describes the network configuration the virtual machine instance
 * @property osProfile OsProfile - describes the configuration of the operating system and sets login data
 * @property provisioningState Provisioning state of the virtual machine instance.
 * @property resourceUid Unique identifier defined by ARC to identify the guest of the VM.
 * @property securityProfile SecurityProfile - Specifies the security settings for the virtual machine instance.
 * @property status The observed state of virtual machine instances
 * @property storageProfile StorageProfile - contains information about the disks and storage information for the virtual machine instance
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vmId Unique identifier for the vm resource.
 */
public data class GetVirtualMachineInstanceResult(
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val guestAgentInstallStatus: GuestAgentInstallStatusResponse? = null,
    public val hardwareProfile: VirtualMachineInstancePropertiesResponseHardwareProfile? = null,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val instanceView: VirtualMachineInstanceViewResponse,
    public val name: String,
    public val networkProfile: VirtualMachineInstancePropertiesResponseNetworkProfile? = null,
    public val osProfile: VirtualMachineInstancePropertiesResponseOsProfile? = null,
    public val provisioningState: String,
    public val resourceUid: String? = null,
    public val securityProfile: VirtualMachineInstancePropertiesResponseSecurityProfile? = null,
    public val status: VirtualMachineInstanceStatusResponse,
    public val storageProfile: VirtualMachineInstancePropertiesResponseStorageProfile? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val vmId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.GetVirtualMachineInstanceResult): GetVirtualMachineInstanceResult = GetVirtualMachineInstanceResult(
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            guestAgentInstallStatus = javaType.guestAgentInstallStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.GuestAgentInstallStatusResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hardwareProfile = javaType.hardwareProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseHardwareProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            instanceView = javaType.instanceView().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstanceViewResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            networkProfile = javaType.networkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseNetworkProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osProfile = javaType.osProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseOsProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resourceUid = javaType.resourceUid().map({ args0 -> args0 }).orElse(null),
            securityProfile = javaType.securityProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseSecurityProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstanceStatusResponse.Companion.toKotlin(args0)
            }),
            storageProfile = javaType.storageProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseStorageProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            vmId = javaType.vmId(),
        )
    }
}
