@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The virtual machine resource definition.
 * @property extendedLocation The extendedLocation of the resource.
 * @property guestAgentProfile Guest agent status properties.
 * @property hardwareProfile HardwareProfile - Specifies the hardware settings for the virtual machine.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity Identity for the resource.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property networkProfile NetworkProfile - describes the network configuration the virtual machine
 * @property osProfile OsProfile - describes the configuration of the operating system and sets login data
 * @property provisioningState Provisioning state of the virtual machine.
 * @property securityProfile SecurityProfile - Specifies the security settings for the virtual machine.
 * @property status The observed state of virtual machines
 * @property storageProfile StorageProfile - contains information about the disks and storage information for the virtual machine
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vmId Unique identifier for the vm resource.
 */
public data class GetVirtualMachineResult(
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val guestAgentProfile: GuestAgentProfileResponse? = null,
    public val hardwareProfile: VirtualMachinePropertiesResponseHardwareProfile? = null,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val location: String,
    public val name: String,
    public val networkProfile: VirtualMachinePropertiesResponseNetworkProfile? = null,
    public val osProfile: VirtualMachinePropertiesResponseOsProfile? = null,
    public val provisioningState: String,
    public val securityProfile: VirtualMachinePropertiesResponseSecurityProfile? = null,
    public val status: VirtualMachineStatusResponse,
    public val storageProfile: VirtualMachinePropertiesResponseStorageProfile? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vmId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.GetVirtualMachineResult): GetVirtualMachineResult = GetVirtualMachineResult(
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            guestAgentProfile = javaType.guestAgentProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.GuestAgentProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hardwareProfile = javaType.hardwareProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseHardwareProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            networkProfile = javaType.networkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseNetworkProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osProfile = javaType.osProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseOsProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            securityProfile = javaType.securityProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseSecurityProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineStatusResponse.Companion.toKotlin(args0)
            }),
            storageProfile = javaType.storageProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseStorageProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vmId = javaType.vmId(),
        )
    }
}
