@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The virtual network resource definition.
 * @property dhcpOptions DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.
 * @property extendedLocation The extendedLocation of the resource.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property networkType Type of the network
 * @property provisioningState Provisioning state of the virtual network.
 * @property status The observed state of virtual networks
 * @property subnets Subnet - list of subnets under the virtual network
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vmSwitchName name of the network switch to be used for VMs
 */
public data class GetVirtualNetworkResult(
    public val dhcpOptions: VirtualNetworkPropertiesResponseDhcpOptions? = null,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val networkType: String? = null,
    public val provisioningState: String,
    public val status: VirtualNetworkStatusResponse,
    public val subnets: List<VirtualNetworkPropertiesResponseSubnets>? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vmSwitchName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.GetVirtualNetworkResult): GetVirtualNetworkResult = GetVirtualNetworkResult(
            dhcpOptions = javaType.dhcpOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualNetworkPropertiesResponseDhcpOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            networkType = javaType.networkType().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualNetworkStatusResponse.Companion.toKotlin(args0)
            }),
            subnets = javaType.subnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualNetworkPropertiesResponseSubnets.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vmSwitchName = javaType.vmSwitchName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
