@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * InterfaceIPConfiguration iPConfiguration in a network interface.
 * @property name Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property properties InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
 */
public data class IPConfigurationResponse(
    public val name: String? = null,
    public val properties: IPConfigurationResponseProperties? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.IPConfigurationResponse): IPConfigurationResponse = IPConfigurationResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.IPConfigurationResponseProperties.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
