@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property end end of the ip address pool
 * @property info
 * @property ipPoolType ip pool type
 * @property name Name of the IP-Pool
 * @property start start of the ip address pool
 */
public data class IPPoolResponse(
    public val end: String? = null,
    public val info: IPPoolInfoResponse? = null,
    public val ipPoolType: String? = null,
    public val name: String? = null,
    public val start: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.IPPoolResponse): IPPoolResponse = IPPoolResponse(
            end = javaType.end().map({ args0 -> args0 }).orElse(null),
            info = javaType.info().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.IPPoolInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ipPoolType = javaType.ipPoolType().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            start = javaType.start().map({ args0 -> args0 }).orElse(null),
        )
    }
}
