@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The InfrastructureNetwork of a AzureStackHCI Cluster.
 * @property dnsServers IPv4 address of the DNS servers in your environment.
 * @property gateway Default gateway that should be used for the provided IP address space.
 * @property ipPools Range of IP addresses from which addresses are allocated for nodes within a subnet.
 * @property subnetMask Subnet mask that matches the provided IP address space.
 * @property useDhcp Allows customers to use DHCP for Hosts and Cluster IPs. If not declared, the deployment will default to static IPs. When true, GW and DNS servers are not required
 */
public data class InfrastructureNetworkResponse(
    public val dnsServers: List<String>? = null,
    public val gateway: String? = null,
    public val ipPools: List<IpPoolsResponse>? = null,
    public val subnetMask: String? = null,
    public val useDhcp: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.InfrastructureNetworkResponse): InfrastructureNetworkResponse = InfrastructureNetworkResponse(
            dnsServers = javaType.dnsServers().map({ args0 -> args0 }),
            gateway = javaType.gateway().map({ args0 -> args0 }).orElse(null),
            ipPools = javaType.ipPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.IpPoolsResponse.Companion.toKotlin(args0)
                })
            }),
            subnetMask = javaType.subnetMask().map({ args0 -> args0 }).orElse(null),
            useDhcp = javaType.useDhcp().map({ args0 -> args0 }).orElse(null),
        )
    }
}
