@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The Intents of a cluster.
 * @property adapter Array of network interfaces used for the network intent.
 * @property adapterPropertyOverrides Set Adapter PropertyOverrides for cluster.
 * @property name Name of the network intent you wish to create.
 * @property overrideAdapterProperty This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
 * @property overrideQosPolicy This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
 * @property overrideVirtualSwitchConfiguration This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
 * @property qosPolicyOverrides Set QoS PolicyOverrides for cluster.
 * @property trafficType List of network traffic types. Only allowed values are 'Compute', 'Storage', 'Management'.
 * @property virtualSwitchConfigurationOverrides Set virtualSwitch ConfigurationOverrides for cluster.
 */
public data class IntentsResponse(
    public val adapter: List<String>? = null,
    public val adapterPropertyOverrides: AdapterPropertyOverridesResponse? = null,
    public val name: String? = null,
    public val overrideAdapterProperty: Boolean? = null,
    public val overrideQosPolicy: Boolean? = null,
    public val overrideVirtualSwitchConfiguration: Boolean? = null,
    public val qosPolicyOverrides: QosPolicyOverridesResponse? = null,
    public val trafficType: List<String>? = null,
    public val virtualSwitchConfigurationOverrides: VirtualSwitchConfigurationOverridesResponse? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.IntentsResponse): IntentsResponse = IntentsResponse(
            adapter = javaType.adapter().map({ args0 -> args0 }),
            adapterPropertyOverrides = javaType.adapterPropertyOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.AdapterPropertyOverridesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            overrideAdapterProperty = javaType.overrideAdapterProperty().map({ args0 -> args0 }).orElse(null),
            overrideQosPolicy = javaType.overrideQosPolicy().map({ args0 -> args0 }).orElse(null),
            overrideVirtualSwitchConfiguration = javaType.overrideVirtualSwitchConfiguration().map({ args0 ->
                args0
            }).orElse(null),
            qosPolicyOverrides = javaType.qosPolicyOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.QosPolicyOverridesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            trafficType = javaType.trafficType().map({ args0 -> args0 }),
            virtualSwitchConfigurationOverrides = javaType.virtualSwitchConfigurationOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualSwitchConfigurationOverridesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
